/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.internal.allocation;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.composer.api.allocation.AllocationProviderPriority;
import org.polarsys.kitalpha.composer.api.allocation.IAllocationProvider;
import org.polarsys.kitalpha.composer.api.allocation.IAllocationProviderDescriptor;
import org.polarsys.kitalpha.composer.api.allocation.IAllocationProviderRegistry;
import org.polarsys.kitalpha.composer.internal.allocation.AllocationProviderDescriptor;
import org.polarsys.kitalpha.composer.metamodel.allocation.base.Root;

public class AllocationProviderRegistry
implements IAllocationProviderRegistry {
    private SortedSet<IAllocationProviderDescriptor> providers = new TreeSet<IAllocationProviderDescriptor>(new AllocationProviderDescriptorComparator());

    public AllocationProviderRegistry() {
        this.loadExtensions();
    }

    @Override
    public void register(IAllocationProviderDescriptor descriptor) {
        this.providers.add(descriptor);
    }

    @Override
    public IAllocationProvider getBestProvider(Root rootAllocation, EObject unknownElement) {
        for (IAllocationProviderDescriptor descriptor : this.providers) {
            if (!descriptor.provides(rootAllocation, unknownElement)) continue;
            return descriptor.getAllocationProvider();
        }
        return null;
    }

    @Override
    public void unregister(IAllocationProviderDescriptor descriptor) {
        this.providers.remove(descriptor);
    }

    private void loadExtensions() {
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("org.polarsys.kitalpha.composer.allocation.provider").getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("allocationProvider".equals(configurationElement.getName())) {
                    AllocationProviderPriority priority = this.getPriority(configurationElement.getAttribute("priority"));
                    AllocationProviderDescriptor descriptor = new AllocationProviderDescriptor(configurationElement, priority);
                    this.register(descriptor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private AllocationProviderPriority getPriority(String attribute) {
        AllocationProviderPriority result = null;
        if ("lowest".equals(attribute)) {
            result = AllocationProviderPriority.LOWEST;
        } else if ("low".equals(attribute)) {
            result = AllocationProviderPriority.LOW;
        } else if ("medium".equals(attribute)) {
            result = AllocationProviderPriority.MEDIUM;
        } else if ("high".equals(attribute)) {
            result = AllocationProviderPriority.HIGH;
        } else if ("highest".equals(attribute)) {
            result = AllocationProviderPriority.HIGHEST;
        }
        return result;
    }

    private static class AllocationProviderDescriptorComparator
    implements Comparator<IAllocationProviderDescriptor> {
        private AllocationProviderDescriptorComparator() {
        }

        @Override
        public int compare(IAllocationProviderDescriptor o1, IAllocationProviderDescriptor o2) {
            if (o1.getPriority() == o2.getPriority()) {
                return o2.getAllocationProviderClassName().compareTo(o1.getAllocationProviderClassName());
            }
            return o2.getPriority().ordinal() - o1.getPriority().ordinal();
        }
    }
}

