/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.kitalpha.massactions.core.helper.container.PossibleFeature;

public class CommonFeaturesHelper {
    private CommonFeaturesHelper() {
    }

    private static Set<EClass> getContainedEClasses(Collection<EObject> objects) {
        return objects.stream().map(EObject::eClass).collect(Collectors.toSet());
    }

    private static Set<PossibleFeature> getAllChangeablePossibleFeatures(EClass eClass) {
        return eClass.getEAllStructuralFeatures().stream().filter(EStructuralFeature::isChangeable).map(PossibleFeature::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Set<PossibleFeature> getAllCommonPossibleFeatures(List<EClass> eClasses) {
        if (eClasses.isEmpty()) {
            return Collections.emptySet();
        }
        EClass initialClass = eClasses.get(0);
        Set<PossibleFeature> possibleFeatures = CommonFeaturesHelper.getAllChangeablePossibleFeatures(initialClass);
        if (eClasses.size() == 1) {
            return possibleFeatures;
        }
        int i = 1;
        while (i < eClasses.size()) {
            EClass nextClass = eClasses.get(i);
            ArrayList<PossibleFeature> nextPossibleFeatures = new ArrayList<PossibleFeature>(CommonFeaturesHelper.getAllChangeablePossibleFeatures(nextClass));
            possibleFeatures.retainAll(nextPossibleFeatures);
            ++i;
        }
        return possibleFeatures;
    }

    public static Collection<PossibleFeature> getCommonPossibleFeatures(Collection<EObject> data) {
        ArrayList<EClass> containedEClasses = new ArrayList<EClass>(CommonFeaturesHelper.getContainedEClasses(data));
        return CommonFeaturesHelper.getAllCommonPossibleFeatures(containedEClasses);
    }

    private static Map<String, EStructuralFeature> mapNamesToStructuralFeatures(EClass eClass) {
        return eClass.getEAllStructuralFeatures().stream().collect(Collectors.toMap(ENamedElement::getName, f -> f));
    }

    public static Map<String, List<EStructuralFeature>> getAllCommonFeaturesMap(List<EObject> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        ArrayList<EClass> containedEClasses = new ArrayList<EClass>(CommonFeaturesHelper.getContainedEClasses(objects));
        HashMap<String, List<EStructuralFeature>> commonFeaturesMap = new HashMap<String, List<EStructuralFeature>>();
        if (containedEClasses.size() == 1) {
            EClass singleEClass = (EClass)containedEClasses.get(0);
            List structuralFeatures = singleEClass.getEAllStructuralFeatures().stream().filter(EStructuralFeature::isChangeable).collect(Collectors.toList());
            commonFeaturesMap.put(singleEClass.getName(), structuralFeatures);
            return commonFeaturesMap;
        }
        ArrayList<PossibleFeature> possibleFeatures = new ArrayList<PossibleFeature>(CommonFeaturesHelper.getAllCommonPossibleFeatures(containedEClasses));
        for (EClass eClass : containedEClasses) {
            String eClassName = eClass.getName();
            Map<String, EStructuralFeature> featureNameMap = CommonFeaturesHelper.mapNamesToStructuralFeatures(eClass);
            ArrayList<EStructuralFeature> commonFeatures = new ArrayList<EStructuralFeature>();
            for (PossibleFeature possibleFeature : possibleFeatures) {
                String possibleFeatureName = possibleFeature.getFeatureName();
                EStructuralFeature actualFeature = featureNameMap.get(possibleFeatureName);
                commonFeatures.add(actualFeature);
            }
            commonFeaturesMap.put(eClassName, commonFeatures);
        }
        return commonFeaturesMap;
    }

    public static Map<String, EStructuralFeature> getAllClassStructuralFeatures(Collection<EObject> data, PossibleFeature feature) {
        Set<EClass> eClasses = CommonFeaturesHelper.getContainedEClasses(data);
        HashMap<String, EStructuralFeature> featuresMap = new HashMap<String, EStructuralFeature>();
        for (EClass eClass : eClasses) {
            String className = eClass.getName();
            EStructuralFeature structuralFeature = CommonFeaturesHelper.mapNamesToStructuralFeatures(eClass).get(feature.getFeatureName());
            featuresMap.put(className, structuralFeature);
        }
        return featuresMap;
    }
}

