/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.NoNullResourceCommand;

public final class DeleteHelper {
    private DeleteHelper() {
    }

    public static void addDeleteLinkedNotesTask(Command command, View deletedView) {
        List<Command> wrappedCommands = DeleteHelper.getWrappedCommands(command);
        if (deletedView.getDiagram().getElement() instanceof DSemanticDiagram) {
            for (Command wrappedCommand : wrappedCommands) {
                if (!(wrappedCommand instanceof DCommand) || !command.canExecute()) continue;
                DCommand cmd = (DCommand)wrappedCommand;
                cmd.getTasks().add(new DeleteRelatedNotesTask(deletedView));
                return;
            }
        }
    }

    public static void addDeleteLinkedNoteAttachmentsTask(Command command, View deletedView) {
        List<Command> wrappedCommands = DeleteHelper.getWrappedCommands(command);
        if (deletedView.getDiagram().getElement() instanceof DSemanticDiagram) {
            for (Command wrappedCommand : wrappedCommands) {
                if (!(wrappedCommand instanceof DCommand) || !command.canExecute()) continue;
                DCommand cmd = (DCommand)wrappedCommand;
                cmd.getTasks().add(new DeleteRelatedNoteAttachmentsTask(deletedView));
                return;
            }
        }
    }

    private static List<Command> getWrappedCommands(Command command) {
        ArrayList<Command> result = new ArrayList<Command>();
        if (command instanceof NoNullResourceCommand) {
            Object adapter = ((NoNullResourceCommand)command).getAdapter(DCommand.class);
            if (adapter instanceof Command) {
                result.addAll(DeleteHelper.getWrappedCommands((Command)adapter));
            }
        } else if (command instanceof CompoundCommand) {
            CompoundCommand cc = (CompoundCommand)command;
            for (Command cmd : cc.getCommandList()) {
                result.addAll(DeleteHelper.getWrappedCommands(cmd));
            }
        }
        if (result.isEmpty()) {
            result.add(command);
        }
        return result;
    }

    private static final class DeleteRelatedNoteAttachmentsTask
    extends AbstractCommandTask {
        private View view;

        DeleteRelatedNoteAttachmentsTask(View deletedView) {
            this.view = deletedView;
        }

        public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
            ArrayList<Edge> linkedViews = new ArrayList<Edge>();
            for (Edge edge : Iterables.filter((Iterable)this.view.getSourceEdges(), Edge.class)) {
                if (!GMFNotationHelper.isNoteAttachment(edge)) continue;
                linkedViews.add(edge);
            }
            for (Edge edge : Iterables.filter((Iterable)this.view.getTargetEdges(), Edge.class)) {
                if (!GMFNotationHelper.isNoteAttachment(edge)) continue;
                linkedViews.add(edge);
            }
            for (View view : linkedViews) {
                EcoreUtil.remove((EObject)view);
            }
        }

        public String getLabel() {
            return Messages.DeleteRelatedNoteAttachmentsTask_label;
        }
    }

    private static final class DeleteRelatedNotesTask
    extends AbstractCommandTask {
        private View view;
        private Set<View> noteToHide = new HashSet<View>();

        DeleteRelatedNotesTask(View deletedView) {
            this.view = deletedView;
        }

        public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
            HashSet<View> allViewsToDelete = new HashSet<View>();
            this.allContentsViewsToDelete(this.view, allViewsToDelete);
            UnmodifiableIterator allContents = Iterators.filter((Iterator)this.view.eAllContents(), View.class);
            while (allContents.hasNext()) {
                Object next = allContents.next();
                this.allContentsViewsToDelete((View)next, allViewsToDelete);
            }
            for (View v : allViewsToDelete) {
                EcoreUtil.remove((EObject)v);
            }
            for (View v : this.noteToHide) {
                v.setVisible(false);
            }
        }

        public String getLabel() {
            return Messages.DeleteRelatedNotesTask_label;
        }

        private Set<View> getAllRelatedNotesToDelete(View viewToDelete) {
            HashSet<Object> linked;
            HashSet<View> linkedViews = new HashSet<View>();
            for (Edge sourceEdge : Iterables.filter((Iterable)viewToDelete.getSourceEdges(), Edge.class)) {
                View target = sourceEdge.getTarget();
                if (!GMFNotationHelper.isNoteAttachment(sourceEdge)) continue;
                linked = new HashSet<View>();
                linked.add(viewToDelete);
                this.collectLinkedViews(target, linked);
                linked.remove(viewToDelete);
                linkedViews.addAll(this.getSafe(linked));
            }
            for (Edge targetEdge : Iterables.filter((Iterable)viewToDelete.getTargetEdges(), Edge.class)) {
                View source = targetEdge.getSource();
                if (!GMFNotationHelper.isNoteAttachment(targetEdge)) continue;
                linked = new HashSet();
                linked.add(viewToDelete);
                this.collectLinkedViews(source, linked);
                linked.remove(viewToDelete);
                linkedViews.addAll(this.getSafe(linked));
            }
            return linkedViews;
        }

        private Collection<? extends View> getSafe(Set<View> linked) {
            for (View linkedView : linked) {
                if (linkedView instanceof Node && GMFNotationHelper.isNote((Node)linkedView)) continue;
                if (!((Node)linkedView).isVisible()) {
                    for (View linkedV : linked) {
                        if (!(linkedV instanceof Node) || !GMFNotationHelper.isNote((Node)linkedV)) continue;
                        this.noteToHide.add(linkedV);
                    }
                }
                return Collections.emptySet();
            }
            return linked;
        }

        private void collectLinkedViews(View v, Set<View> linkedViews) {
            linkedViews.add(v);
            for (Edge sourceEdge : Iterables.filter((Iterable)v.getSourceEdges(), Edge.class)) {
                View target = sourceEdge.getTarget();
                if (!GMFNotationHelper.isNoteAttachment(sourceEdge)) continue;
                if (!linkedViews.contains(target) && target instanceof Node && GMFNotationHelper.isNote((Node)target)) {
                    this.collectLinkedViews(target, linkedViews);
                    continue;
                }
                linkedViews.add(target);
            }
            for (Edge targetEdge : Iterables.filter((Iterable)v.getTargetEdges(), Edge.class)) {
                View source = targetEdge.getSource();
                if (!GMFNotationHelper.isNoteAttachment(targetEdge)) continue;
                if (!linkedViews.contains(source) && source instanceof Node && GMFNotationHelper.isNote((Node)source)) {
                    this.collectLinkedViews(source, linkedViews);
                    continue;
                }
                linkedViews.add(source);
            }
        }

        private void allContentsViewsToDelete(View viewToDelete, Set<View> allViewsToDelete) {
            allViewsToDelete.addAll(this.getAllRelatedNotesToDelete(viewToDelete));
            for (Edge edge : Iterables.filter((Iterable)Iterables.concat((Iterable)viewToDelete.getSourceEdges(), (Iterable)viewToDelete.getTargetEdges()), Edge.class)) {
                if (!GMFNotationHelper.isNoteAttachment(edge)) continue;
                allViewsToDelete.add((View)edge);
            }
        }
    }
}

