/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.ui.IWorkbenchPage;

public class SizeBothAction
extends org.eclipse.gmf.runtime.diagram.ui.actions.internal.SizeBothAction {
    public SizeBothAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected boolean calculateEnabled() {
        boolean enabled = super.calculateEnabled();
        return enabled && this.canEditInstance();
    }

    protected Command getCommand() {
        CompoundCommand doResizeCmd = new CompoundCommand();
        Iterator iter = this.getSelectedObjects().iterator();
        int last = this.getSelectedObjects().size() - 1;
        IGraphicalEditPart primary = (IGraphicalEditPart)this.getSelectedObjects().get(last);
        if (this.concernRegion((EditPart)primary)) {
            List<AbstractDiagramElementContainerEditPart> primaryRegions = this.getRegionParts((AbstractDiagramContainerEditPart)primary);
            while (iter.hasNext()) {
                int primarySize;
                List<AbstractDiagramElementContainerEditPart> toResizeRegions;
                int toResizeSize;
                IGraphicalEditPart toResize = (IGraphicalEditPart)iter.next();
                if (toResize == primary || !this.concernRegion((EditPart)toResize) || (toResizeSize = (toResizeRegions = this.getRegionParts((AbstractDiagramContainerEditPart)toResize)).size()) > (primarySize = primaryRegions.size())) continue;
                int i = 0;
                while (i < toResizeSize) {
                    AbstractDiagramElementContainerEditPart toResizeRegion = toResizeRegions.get(i);
                    AbstractDiagramElementContainerEditPart primaryRegion = primaryRegions.get(i);
                    Dimension newDimension = null;
                    if (i == toResizeSize - 1 && primarySize > toResizeSize) {
                        newDimension = this.computeLastRegionDimension(primary, primaryRegions, primarySize, i, primaryRegion);
                    }
                    if (newDimension == null) {
                        newDimension = this.getPrimaryRegionSize(primaryRegion);
                    }
                    View resizeView = (View)toResizeRegion.getModel();
                    doResizeCmd.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(toResize.getEditingDomain(), "", (IAdaptable)new EObjectAdapter((EObject)resizeView), newDimension)));
                    ++i;
                }
            }
            return doResizeCmd.unwrap();
        }
        return super.getCommand();
    }

    private Dimension computeLastRegionDimension(IGraphicalEditPart primary, List<AbstractDiagramElementContainerEditPart> primaryRegions, int primarySize, int currentIndex, AbstractDiagramElementContainerEditPart primaryRegion) {
        Dimension newDimension = null;
        Optional<DNodeContainer> optional = Optional.of(((AbstractDiagramContainerEditPart)primary).resolveDiagramElement()).filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast);
        if (optional.isPresent()) {
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery(optional.get());
            newDimension = this.getPrimaryRegionSize(primaryRegion);
            int j = currentIndex + 1;
            while (j < primarySize) {
                Dimension tempDim = this.getPrimaryRegionSize(primaryRegions.get(j));
                if (query.isHorizontaltackContainer()) {
                    newDimension.expand(tempDim.width, 0);
                } else {
                    newDimension.expand(0, tempDim.height);
                }
                ++j;
            }
        }
        return newDimension;
    }

    private Dimension getPrimaryRegionSize(AbstractDiagramElementContainerEditPart primaryRegion) {
        View primaryView = (View)primaryRegion.getModel();
        Integer width = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        Integer height = (Integer)ViewUtil.getStructuralFeatureValue((View)primaryView, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension newDimension = width == -1 || height == -1 ? primaryRegion.getFigure().getSize().getCopy() : new Dimension(width.intValue(), height.intValue());
        return newDimension;
    }

    protected boolean canEditInstance() {
        boolean canEditInstance = true;
        if (this.getWorkbenchPart() instanceof DDiagramEditor && ((DDiagramEditor)this.getWorkbenchPart()).getRepresentation() instanceof DDiagram) {
            DDiagramEditor editor = (DDiagramEditor)this.getWorkbenchPart();
            DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
            Resource sessionResource = editor.getSession().getSessionResource();
            if (sessionResource != null) {
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(sessionResource.getResourceSet());
                canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
            }
        }
        return canEditInstance;
    }

    private boolean concernRegion(EditPart hostPart) {
        if (hostPart instanceof AbstractDiagramContainerEditPart) {
            return ((AbstractDiagramContainerEditPart)hostPart).isRegionContainer();
        }
        return false;
    }

    private List<AbstractDiagramElementContainerEditPart> getRegionParts(AbstractDiagramContainerEditPart host) {
        AbstractDNodeContainerCompartmentEditPart comp = (AbstractDNodeContainerCompartmentEditPart)Iterables.getFirst((Iterable)Iterables.filter((Iterable)host.getChildren(), AbstractDNodeContainerCompartmentEditPart.class), null);
        if (comp != null) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)comp.getChildren(), AbstractDiagramElementContainerEditPart.class));
        }
        return Collections.emptyList();
    }
}

