/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.view.factories;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.ui.internal.view.factories.AbstractDesignerNodeFactory;

public class AbstractContainerViewFactory
extends AbstractDesignerNodeFactory {
    private static final Integer AUTO_SIZE = -1;
    private static final Adapter JUST_CREATED = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type.equals(AbstractContainerViewFactory.class);
        }

        public Notifier getTarget() {
            return null;
        }
    };

    protected void updateLayoutConstraint(View view, IAdaptable semanticAdapter) {
        if (view instanceof Node && ((Node)view).getLayoutConstraint() instanceof Size) {
            Size size = (Size)((Node)view).getLayoutConstraint();
            DDiagramElementContainer viewNodecontainer = (DDiagramElementContainer)semanticAdapter.getAdapter(DDiagramElementContainer.class);
            if (viewNodecontainer != null) {
                Integer width = viewNodecontainer.getWidth();
                Integer height = viewNodecontainer.getHeight();
                if (width == null || width <= 0) {
                    width = AUTO_SIZE;
                }
                if (height == null || height <= 0) {
                    height = AUTO_SIZE;
                }
                this.computeWidthAndHeightExpressions(view, size, viewNodecontainer, width, height);
            }
        }
    }

    private void computeWidthAndHeightExpressions(View view, Size size, DDiagramElementContainer viewNodecontainer, Integer width, Integer height) {
        boolean hasToBeMarked = false;
        if (!height.equals(AUTO_SIZE)) {
            size.setHeight(height * 10);
            hasToBeMarked = true;
        }
        if (!width.equals(AUTO_SIZE)) {
            size.setWidth(width * 10);
            hasToBeMarked = true;
        }
        if (hasToBeMarked) {
            view.eAdapters().add((Object)JUST_CREATED);
        }
    }
}

