/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.engine.internal.utils.AcceleoEngineCreatorDescriptor;

public final class AcceleoEngineRegistry {
    private static final List<AcceleoEngineCreatorDescriptor> CREATORS = new ArrayList<AcceleoEngineCreatorDescriptor>();

    private AcceleoEngineRegistry() {
    }

    public static void addCreator(AcceleoEngineCreatorDescriptor creator) {
        CREATORS.add(creator);
    }

    public static void clearRegistry() {
        CREATORS.clear();
    }

    public static List<AcceleoEngineCreatorDescriptor> getRegisteredCreators() {
        return new ArrayList<AcceleoEngineCreatorDescriptor>(CREATORS);
    }

    public static void removeCreator(String engineClassName) {
        for (AcceleoEngineCreatorDescriptor creator : AcceleoEngineRegistry.getRegisteredCreators()) {
            if (!creator.getClassName().equals(engineClassName)) continue;
            CREATORS.remove(creator);
        }
    }
}

