/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.eef.runtime.impl.utils.ModelViewerHelper;
import org.eclipse.emf.eef.runtime.ui.utils.EEFLabelProvider;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.widgets.IPropertiesFilteredWidget;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.AdvancedEEFEditorContentProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementSelectionDialog
extends Dialog
implements IPropertiesFilteredWidget {
    protected Label label;
    protected Tree tree;
    protected String title = EEFRuntimeUIMessages.TabElementTreeSelectionDialog_title;
    private List<ViewerFilter> viewerFilters;
    private List<ViewerFilter> brFilters;
    protected AdapterFactory adapterFactory;
    private Composite parent;
    private Object input;
    private IStructuredSelection selection;

    public ElementSelectionDialog(Object input, List<ViewerFilter> filters, List<ViewerFilter> brFilters, String title, AdapterFactory adapterFactory) {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(0x10 | super.getShellStyle());
        this.input = input;
        this.viewerFilters = filters;
        this.brFilters = brFilters;
        this.title = title;
        this.adapterFactory = adapterFactory;
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        return this.fillModelpage(parent);
    }

    public Control fillModelpage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        TreeSelectionPatternFilter patternFilter = new TreeSelectionPatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filteredTree = new FilteredTree(composite, 2580, (PatternFilter)patternFilter, true);
        TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.setFilters(new ViewerFilter[0]);
        treeViewer.setUseHashlookup(true);
        if (this.input instanceof EEFEditorSettings) {
            treeViewer.setContentProvider((IContentProvider)new HideResourcesContentProvider((ITreeContentProvider)new AdvancedEEFEditorContentProvider(this.adapterFactory)));
        } else {
            treeViewer.setContentProvider((IContentProvider)new HideResourcesContentProvider((ITreeContentProvider)new AdapterFactoryContentProvider(this.adapterFactory)));
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.viewerFilters != null && !this.viewerFilters.isEmpty()) {
            for (ViewerFilter filter : this.viewerFilters) {
                filters.add(filter);
            }
        }
        if (this.brFilters != null && !this.brFilters.isEmpty()) {
            for (ViewerFilter filter : this.brFilters) {
                filters.add(filter);
            }
        }
        filters.add((Object)patternFilter);
        ViewerFilter[] v = filters.toArray(new ViewerFilter[filters.size()]);
        treeViewer.setFilters(v);
        treeViewer.setLabelProvider((IBaseLabelProvider)new EEFLabelProvider(){

            public Color getForeground(Object element) {
                if (ElementSelectionDialog.this.input instanceof ReferencesTableSettings && element instanceof EObject && ((ReferencesTableSettings)ElementSelectionDialog.this.input).contains((EObject)element)) {
                    return ElementSelectionDialog.this.getShell().getDisplay().getSystemColor(18);
                }
                return super.getForeground(element);
            }
        });
        filteredTree.setLayoutData((Object)new GridData(550, 300));
        if (this.input instanceof EEFEditorSettings) {
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection structuredSelection;
                    if (event.getSelection() instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)event.getSelection()) != null && !structuredSelection.isEmpty()) {
                        Object o = structuredSelection.getFirstElement();
                        Button okButton = ElementSelectionDialog.this.getButton(0);
                        if (((List)((EEFEditorSettings)ElementSelectionDialog.this.input).choiceOfValues(ElementSelectionDialog.this.adapterFactory)).contains(o)) {
                            if (ElementSelectionDialog.this.input instanceof ReferencesTableSettings) {
                                if (o instanceof EObject && !((ReferencesTableSettings)ElementSelectionDialog.this.input).contains((EObject)o)) {
                                    ElementSelectionDialog.this.selection = structuredSelection;
                                    if (okButton != null) {
                                        okButton.setEnabled(true);
                                    }
                                } else if (okButton != null) {
                                    okButton.setEnabled(false);
                                }
                            } else {
                                ElementSelectionDialog.this.selection = structuredSelection;
                                if (okButton != null) {
                                    okButton.setEnabled(true);
                                }
                            }
                        } else if (okButton != null) {
                            okButton.setEnabled(false);
                        }
                    }
                }
            });
            treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (ElementSelectionDialog.this.selection != null && !ElementSelectionDialog.this.selection.isEmpty()) {
                        Object o = ElementSelectionDialog.this.selection.getFirstElement();
                        if (((List)((EEFEditorSettings)ElementSelectionDialog.this.input).choiceOfValues(ElementSelectionDialog.this.adapterFactory)).contains(o) && ElementSelectionDialog.this.input instanceof ReferencesTableSettings && o instanceof EObject && !((ReferencesTableSettings)ElementSelectionDialog.this.input).contains((EObject)o)) {
                            ElementSelectionDialog.this.okPressed();
                        }
                    }
                }
            });
        }
        treeViewer.setInput(this.input);
        if (this.selection != null) {
            treeViewer.setSelection((ISelection)this.selection);
        }
        return composite;
    }

    public void setInput(Object input) {
        this.input = input;
        this.refresh();
    }

    public void refresh() {
        this.parent.pack();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(String.valueOf(EEFRuntimeUIMessages.TabElementTreeSelectionDialog_shell_title) + this.title);
    }

    protected void okPressed() {
        if (this.selection != null && !this.selection.isEmpty()) {
            this.process(this.selection);
            ModelViewerHelper.setLastSelection(this.selection);
        }
        super.okPressed();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public abstract void process(IStructuredSelection var1);

    @Override
    public void addBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.add(filter);
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        this.viewerFilters.add(filter);
    }

    @Override
    public void removeBusinessRuleFilter(ViewerFilter filter) {
        this.brFilters.remove(filter);
    }

    @Override
    public void removeFilter(ViewerFilter filter) {
        this.viewerFilters.remove(filter);
    }

    private class HideResourcesContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider delegateContentProvider;

        public HideResourcesContentProvider(ITreeContentProvider delegateContentProvider) {
            this.delegateContentProvider = delegateContentProvider;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.delegateContentProvider.getElements(inputElement);
            ArrayList<Object> newElements = new ArrayList<Object>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof Resource) {
                    newElements.addAll((Collection<Object>)((Resource)element).getContents());
                } else {
                    newElements.add(element);
                }
                ++n2;
            }
            return newElements.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.delegateContentProvider.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getChildren(Object parentElement) {
            return this.delegateContentProvider.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return this.delegateContentProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.delegateContentProvider.hasChildren(element);
        }

        public void dispose() {
            this.delegateContentProvider.dispose();
        }
    }

    private class TreeSelectionPatternFilter
    extends PatternFilter {
        private TreeSelectionPatternFilter() {
        }

        protected boolean isParentMatch(Viewer viewer, Object element) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            if (ElementSelectionDialog.this.viewerFilters != null && !ElementSelectionDialog.this.viewerFilters.isEmpty() && children != null) {
                for (ViewerFilter viewerFilter : ElementSelectionDialog.this.viewerFilters) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (viewerFilter.select(viewer, null, child)) {
                            return super.isParentMatch(viewer, element);
                        }
                        ++n2;
                    }
                }
                return false;
            }
            return super.isParentMatch(viewer, element);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            String labelText;
            if (element instanceof EObject && (labelText = ((EObject)element).toString()) != null) {
                return this.wordMatches(labelText);
            }
            return false;
        }
    }
}

