/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.PrintWriter;
import org.eclipse.ui.internal.intro.universal.BaseData;
import org.eclipse.ui.internal.intro.universal.Messages;

public class ExtensionData
extends BaseData {
    public static final int HIDDEN = -1;
    public static final int CALLOUT = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int NEW = 4;
    private String name;
    private int fImportance = 1;
    private boolean implicit = false;
    public static final String[] IMPORTANCE_TABLE = new String[]{"callout", "low", "medium", "high", "new"};
    public static final String[] IMPORTANCE_STYLE_TABLE = new String[]{"importance-callout", "importance-low", "importance-medium", "importance-high", "importance-new"};
    public static final String[] IMPORTANCE_NAME_TABLE = new String[]{Messages.ExtensionData_callout, Messages.ExtensionData_low, Messages.ExtensionData_medium, Messages.ExtensionData_high, Messages.ExtensionData_new};

    public ExtensionData(String id, String name) {
        this(id, name, "low", false);
    }

    public ExtensionData(String id, String name, int importance) {
        this.id = id;
        this.name = name;
        this.fImportance = importance;
        this.implicit = false;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public ExtensionData(String id, String name, String importance, boolean implicit) {
        this.id = id;
        this.name = name;
        this.implicit = implicit;
        if (importance != null) {
            if (importance.equals("high")) {
                this.fImportance = 3;
            } else if (importance.equals("medium")) {
                this.fImportance = 2;
            } else if (importance.equals("low")) {
                this.fImportance = 1;
            } else if (importance.equals("callout")) {
                this.fImportance = 0;
            } else if (importance.equals("new")) {
                this.fImportance = 4;
            } else if (importance.equals("hidden")) {
                this.fImportance = -1;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getImportance() {
        return this.fImportance;
    }

    public void setImportance(int newValue) {
        this.fImportance = newValue;
    }

    public boolean isHidden() {
        return this.fImportance == -1;
    }

    String getImportanceAttributeValue() {
        return IMPORTANCE_TABLE[this.fImportance];
    }

    public String toString() {
        return this.name != null ? this.name : this.id;
    }

    @Override
    public void write(PrintWriter writer, String indent) {
        writer.print(indent);
        writer.print("<extension id=\"" + this.id + "\"");
        if (!this.isHidden()) {
            writer.println(" importance=\"" + this.getImportanceAttributeValue() + "\"/>");
        } else {
            writer.println("/>");
        }
    }
}

