/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.color;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class AcceleoColorManager {
    private static Map<RGB, Color> colors = new HashMap<RGB, Color>(10);

    private AcceleoColorManager() {
    }

    public static void dispose() {
        Iterator<Color> e = colors.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        colors.clear();
    }

    public static Color getColor(AcceleoColor color, IEclipsePreferences[] preferenceLookupOrder) {
        return AcceleoColorManager.getColor(color.getPreferenceKey(), color.getDefault(), preferenceLookupOrder);
    }

    public static Color getColor(AcceleoColor color) {
        return AcceleoColorManager.getColor(color, null);
    }

    private static Color getColor(String key, RGB defaultValue, IEclipsePreferences[] preferenceLookupOrder) {
        RGB rgbValue = AcceleoColorManager.getPreference(key, defaultValue, preferenceLookupOrder);
        return AcceleoColorManager.getColor(rgbValue);
    }

    private static RGB getPreference(String key, RGB defaultValue, IEclipsePreferences[] preferenceLookupOrder) {
        String rgbValue;
        if (key.length() > 0 && (rgbValue = AcceleoUIActivator.getPreferenceValue(key, preferenceLookupOrder)) != null) {
            return StringConverter.asRGB((String)rgbValue);
        }
        return defaultValue;
    }

    private static Color getColor(RGB rgb) {
        Color color = colors.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colors.put(rgb, color);
        }
        return color;
    }
}

