/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.revision;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.SafeRunnable;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EditableRevision
extends FileRevisionTypedElement
implements IEditableContent,
IContentChangeNotifier {
    private final CopyOnWriteArrayList<IContentChangeListener> listeners = new CopyOnWriteArrayList();
    private byte[] modifiedContent;
    private IStorageEditorInput input;

    public EditableRevision(IFileRevision fileRevision, String encoding) {
        super(fileRevision, encoding);
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    @Override
    public InputStream getContents() throws CoreException {
        if (this.modifiedContent != null) {
            return new ByteArrayInputStream(this.modifiedContent);
        }
        return super.getContents();
    }

    public void setContent(byte[] newContent) {
        this.modifiedContent = newContent;
        this.fireContentChanged();
    }

    public byte[] getModifiedContent() {
        return this.modifiedContent;
    }

    @Override
    public IEditorInput getDocumentKey(Object element) {
        if (element == this) {
            if (this.input == null) {
                this.input = new IStorageEditorInput(){
                    private IStorage storage;

                    public boolean exists() {
                        return true;
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return null;
                    }

                    public String getName() {
                        return EditableRevision.this.getName();
                    }

                    public IPersistableElement getPersistable() {
                        return null;
                    }

                    public String getToolTipText() {
                        return EditableRevision.this.getName();
                    }

                    public <T> T getAdapter(Class<T> adapter) {
                        return null;
                    }

                    public IStorage getStorage() throws CoreException {
                        if (this.storage == null) {
                            this.storage = new IEncodedStorage(){

                                public <T> T getAdapter(Class<T> adapter) {
                                    return null;
                                }

                                public boolean isReadOnly() {
                                    return false;
                                }

                                public String getName() {
                                    return EditableRevision.this.getName();
                                }

                                public IPath getFullPath() {
                                    return null;
                                }

                                public InputStream getContents() throws CoreException {
                                    return EditableRevision.this.getContents();
                                }

                                public String getCharset() throws CoreException {
                                    return EditableRevision.this.getCharset();
                                }
                            };
                        }
                        return this.storage;
                    }
                };
            }
            return this.input;
        }
        return super.getDocumentKey(element);
    }

    @Override
    protected ISharedDocumentAdapter createSharedDocumentAdapter() {
        return new EditableRevisionSharedDocumentAdapter(this);
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireContentChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        Runnable runnable = () -> {
            for (IContentChangeListener listener : this.listeners) {
                SafeRunnable.run(() -> listener.contentChanged((IContentChangeNotifier)this));
            }
        };
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static class EditableRevisionSharedDocumentAdapter
    extends EditableSharedDocumentAdapter {
        private final EditableRevision editable;

        public EditableRevisionSharedDocumentAdapter(EditableRevision editable) {
            super(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                }

                public void handleDocumentDisconnected() {
                }

                public void handleDocumentFlushed() {
                }

                public void handleDocumentDeleted() {
                }

                public void handleDocumentSaved() {
                }
            });
            this.editable = editable;
        }

        public void flushDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite) throws CoreException {
            super.flushDocument(provider, documentKey, document, overwrite);
            if (document != null && this.editable.input != null) {
                try {
                    String charset = this.editable.getCharset();
                    if (charset == null) {
                        this.editable.setContent(document.get().getBytes());
                    } else {
                        this.editable.setContent(document.get().getBytes(charset));
                    }
                    this.saveDocument(documentKey, overwrite, null);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException(Activator.createErrorStatus(MessageFormat.format(UIText.EditableRevision_CannotSave, this.editable.getName(), this.editable.getContentIdentifier()), e));
                }
            }
        }

        public IEditorInput getDocumentKey(Object element) {
            return this.editable.getDocumentKey(element);
        }
    }
}

