/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public class P2Utils {
    public static final String P2_FLAVOR_DEFAULT = "tooling";
    public static final ITouchpointType TOUCHPOINT_OSGI = MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.osgi", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_FRAGMENT = "osgi.fragment";
    public static final String TYPE_ECLIPSE_BUNDLE = "bundle";
    public static final String NAMESPACE_ECLIPSE_TYPE = "org.eclipse.equinox.p2.eclipse.type";
    public static final IProvidedCapability BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final String CAPABILITY_NS_JAVA_PACKAGE = "java.package";

    public static URL[] readBundlesTxt(String platformHome, URL configurationArea) {
        BundleInfo[] bundles;
        block6: {
            if (configurationArea == null) {
                return null;
            }
            try {
                bundles = P2Utils.readBundles(platformHome, configurationArea);
                if (bundles != null) break block6;
                return null;
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
                return null;
            }
        }
        int length = bundles.length;
        BundleInfo[] srcBundles = P2Utils.readSourceBundles(platformHome, configurationArea);
        if (srcBundles != null) {
            length += srcBundles.length;
        }
        URL[] urls = new URL[length];
        P2Utils.copyURLs(urls, 0, bundles);
        if (srcBundles != null && srcBundles.length > 0) {
            P2Utils.copyURLs(urls, bundles.length, srcBundles);
        }
        return urls;
    }

    public static BundleInfo[] readBundles(String platformHome, URL configurationArea) {
        BundleInfo[] bundles;
        block5: {
            Path basePath = new Path(platformHome);
            if (configurationArea == null) {
                return null;
            }
            URL bundlesTxt = new URL(configurationArea.getProtocol(), configurationArea.getHost(), new File(configurationArea.getFile(), "org.eclipse.equinox.simpleconfigurator/bundles.info").getAbsolutePath());
            File home = basePath.toFile();
            bundles = P2Utils.getBundlesFromFile(bundlesTxt, home);
            if (bundles != null && bundles.length != 0) break block5;
            return null;
        }
        try {
            return bundles;
        }
        catch (MalformedURLException e) {
            PDECore.log(e);
            return null;
        }
        catch (IOException e) {
            PDECore.log(e);
            return null;
        }
    }

    public static BundleInfo[] readSourceBundles(String platformHome, URL configurationArea) {
        BundleInfo[] srcBundles;
        block5: {
            Path basePath = new Path(platformHome);
            if (configurationArea == null) {
                return null;
            }
            File home = basePath.toFile();
            URL srcBundlesTxt = new URL(configurationArea.getProtocol(), configurationArea.getHost(), configurationArea.getFile().concat("org.eclipse.equinox.source/source.info"));
            srcBundles = P2Utils.getBundlesFromFile(srcBundlesTxt, home);
            if (srcBundles != null && srcBundles.length != 0) break block5;
            return null;
        }
        try {
            return srcBundles;
        }
        catch (MalformedURLException e) {
            PDECore.log(e);
            return null;
        }
        catch (IOException e) {
            PDECore.log(e);
            return null;
        }
    }

    private static void copyURLs(URL[] dest, int start, BundleInfo[] infos) throws MalformedURLException {
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            dest[start++] = new File(info.getLocation()).toURL();
            ++n2;
        }
    }

    private static BundleInfo[] getBundlesFromFile(URL fileURL, File home) throws IOException {
        SimpleConfiguratorManipulator manipulator = PDECore.getDefault().acquireService(SimpleConfiguratorManipulator.class);
        if (manipulator == null) {
            return null;
        }
        try {
            return manipulator.loadConfiguration(fileURL.openStream(), home.toURI());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static URL writeBundlesTxt(Map<?, ?> bundles, int defaultStartLevel, boolean defaultAutoStart, File directory, String osgiBundleList) {
        if (bundles.isEmpty()) {
            return null;
        }
        HashMap<Object, String> osgiStartLevels = new HashMap<Object, String>();
        if (osgiBundleList != null) {
            StringTokenizer tokenizer = new StringTokenizer(osgiBundleList, ",");
            while (tokenizer.hasMoreTokens()) {
                String auto;
                String token = tokenizer.nextToken();
                int index = token.indexOf(64);
                if (index == -1) continue;
                String modelName = token.substring(0, index);
                String startData = token.substring(index + 1);
                String level = (index = startData.indexOf(58)) > 0 ? startData.substring(0, index) : "default";
                String string = auto = index > 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
                if ("start".equals(auto)) {
                    auto = "true";
                }
                osgiStartLevels.put(modelName, String.valueOf(level) + ':' + auto);
            }
        }
        ArrayList<BundleInfo> bundleInfo = new ArrayList<BundleInfo>(bundles.size());
        ArrayList<BundleInfo> sourceInfo = new ArrayList<BundleInfo>(bundles.size());
        for (Object name : bundles.keySet()) {
            IPluginModelBase currentModel = (IPluginModelBase)name;
            IPluginBase base = currentModel.getPluginBase();
            BundleInfo info = new BundleInfo();
            String installLocation = currentModel.getInstallLocation();
            if (installLocation != null) {
                int index;
                info.setLocation(new File(installLocation).toURI());
                if (base instanceof PluginBase && ((PluginBase)base).getBundleSourceEntry() != null) {
                    info.setSymbolicName(base.getId());
                    info.setVersion(base.getVersion());
                    info.setStartLevel(-1);
                    info.setMarkedAsStarted(false);
                    sourceInfo.add(info);
                    continue;
                }
                if (base == null) continue;
                info.setSymbolicName(base.getId());
                info.setVersion(base.getVersion());
                String currentLevel = (String)bundles.get(currentModel);
                if (osgiStartLevels.containsKey(base.getId())) {
                    currentLevel = (String)osgiStartLevels.get(base.getId());
                }
                String levelString = (index = currentLevel.indexOf(58)) > 0 ? currentLevel.substring(0, index) : "default";
                String auto = index > 0 && index < currentLevel.length() - 1 ? currentLevel.substring(index + 1) : "default";
                boolean isAuto = true;
                int level = -1;
                isAuto = "default".equals(auto) ? defaultAutoStart : Boolean.parseBoolean(auto);
                if ("default".equals(levelString)) {
                    level = defaultStartLevel;
                } else {
                    try {
                        level = Integer.parseInt(levelString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", "Error writing bundles, could not parse start level for bundle " + currentModel));
                    }
                }
                info.setMarkedAsStarted(isAuto);
                info.setStartLevel(level);
                bundleInfo.add(info);
                continue;
            }
            PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", "Error writing bundles, could not find the bundle location for bundle " + currentModel));
        }
        File bundlesTxt = new File(directory, "org.eclipse.equinox.simpleconfigurator/bundles.info");
        File srcBundlesTxt = new File(directory, "org.eclipse.equinox.source/source.info");
        BundleInfo[] infos = bundleInfo.toArray(new BundleInfo[bundleInfo.size()]);
        BundleInfo[] sources = sourceInfo.toArray(new BundleInfo[sourceInfo.size()]);
        SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)BundleHelper.getDefault().acquireService(SimpleConfiguratorManipulator.class);
        try {
            manipulator.saveConfiguration(infos, bundlesTxt, null);
            manipulator.saveConfiguration(sources, srcBundlesTxt, null);
        }
        catch (IOException e) {
            PDECore.logException(e);
            return null;
        }
        if (!bundlesTxt.exists()) {
            return null;
        }
        try {
            return bundlesTxt.toURL();
        }
        catch (MalformedURLException e) {
            PDECore.logException(e);
            return null;
        }
    }

    public static boolean profileExists(String profileID, File p2DataArea) throws CoreException {
        IProvisioningAgentProvider provider = PDECore.getDefault().acquireService(IProvisioningAgentProvider.class);
        if (provider == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProvisioningAgent agent = provider.createAgent(p2DataArea.toURI());
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        return registry.containsProfile(profileID);
    }

    public static void createProfile(String profileID, File p2DataArea, Collection<?> bundles) throws CoreException {
        IProvisioningAgentProvider provider = PDECore.getDefault().acquireService(IProvisioningAgentProvider.class);
        if (provider == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProvisioningAgent agent = provider.createAgent(p2DataArea.toURI());
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        registry.removeProfile(profileID);
        IProfile profile = null;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
        props.put("org.eclipse.equinox.p2.environments", P2Utils.generateEnvironmentProperties());
        props.put("org.eclipse.equinox.p2.nl", TargetPlatform.getNL());
        profile = registry.addProfile(profileID, props);
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>(bundles.size());
        for (Object name : bundles) {
            IPluginModelBase model = (IPluginModelBase)name;
            BundleDescription bundle = model.getBundleDescription();
            ius.add(P2Utils.createBundleIU(bundle));
        }
        ProvisioningContext context = new ProvisioningContext(agent);
        IProvisioningPlan plan = engine.createPlan(profile, context);
        for (IInstallableUnit iu : ius) {
            plan.addInstallableUnit(iu);
            plan.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.internal.inclusion.rules", ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
        }
        IPhaseSet phaseSet = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_CHECK_TRUST, PhaseSetFactory.PHASE_COLLECT, PhaseSetFactory.PHASE_CONFIGURE, PhaseSetFactory.PHASE_UNCONFIGURE, PhaseSetFactory.PHASE_UNINSTALL});
        IStatus status = engine.perform(plan, phaseSet, (IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK() && status.getSeverity() != 8) {
            throw new CoreException(status);
        }
    }

    private static String generateEnvironmentProperties() {
        StringBuilder env = new StringBuilder();
        env.append("osgi.ws=");
        env.append(TargetPlatform.getWS());
        env.append(",");
        env.append("osgi.os=");
        env.append(TargetPlatform.getOS());
        env.append(",");
        env.append("osgi.arch=");
        env.append(TargetPlatform.getOSArch());
        return env.toString();
    }

    private static IInstallableUnit createBundleIU(BundleDescription bd) {
        ExportPackageDescription[] exports;
        ImportPackageSpecification[] osgiImports;
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(bd.isSingleton());
        iu.setId(bd.getSymbolicName());
        iu.setVersion(P2Utils.fromOSGiVersion(bd.getVersion()));
        iu.setFilter(bd.getPlatformFilter());
        iu.setTouchpointType(TOUCHPOINT_OSGI);
        boolean isFragment = bd.getHost() != null;
        BundleSpecification[] requiredBundles = bd.getRequiredBundles();
        ArrayList<IRequirement> reqsDeps = new ArrayList<IRequirement>();
        if (isFragment) {
            reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)bd.getHost().getName(), (VersionRange)P2Utils.fromOSGiVersionRange(bd.getHost().getVersionRange()), null, (boolean)false, (boolean)false));
        }
        BundleSpecification[] bundleSpecificationArray = requiredBundles;
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)requiredBundle.getName(), (VersionRange)P2Utils.fromOSGiVersionRange(requiredBundle.getVersionRange()), null, (boolean)requiredBundle.isOptional(), (boolean)false));
            ++n2;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = osgiImports = bd.getImportPackages();
        int n3 = osgiImports.length;
        n = 0;
        while (n < n3) {
            ImportPackageSpecification importSpec = importPackageSpecificationArray[n];
            String importPackageName = importSpec.getName();
            if (importPackageName.indexOf(42) == -1) {
                VersionRange versionRange = P2Utils.fromOSGiVersionRange(importSpec.getVersionRange());
                boolean isOptional = importSpec.getDirective("resolution").equals("dynamic") || importSpec.getDirective("resolution").equals("optional");
                reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_JAVA_PACKAGE, (String)importPackageName, (VersionRange)versionRange, null, (boolean)isOptional, (boolean)false));
            }
            ++n;
        }
        iu.setRequirements(reqsDeps.toArray(new IRequirement[reqsDeps.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)bd.getSymbolicName(), (Version)P2Utils.fromOSGiVersion(bd.getVersion())));
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_BUNDLE, (String)bd.getSymbolicName(), (Version)P2Utils.fromOSGiVersion(bd.getVersion())));
        ExportPackageDescription[] exportPackageDescriptionArray = exports = bd.getExportPackages();
        int n4 = exports.length;
        int n5 = 0;
        while (n5 < n4) {
            ExportPackageDescription export = exportPackageDescriptionArray[n5];
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_JAVA_PACKAGE, (String)export.getName(), (Version)P2Utils.fromOSGiVersion(export.getVersion())));
            ++n5;
        }
        providedCapabilities.add(BUNDLE_CAPABILITY);
        if (isFragment) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_FRAGMENT, (String)bd.getHost().getName(), (Version)P2Utils.fromOSGiVersion(bd.getVersion())));
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private static Version fromOSGiVersion(org.osgi.framework.Version version) {
        if (version == null) {
            return Version.MAX_VERSION;
        }
        if (version.getMajor() == Integer.MAX_VALUE && version.getMicro() == Integer.MAX_VALUE && version.getMicro() == Integer.MAX_VALUE) {
            return Version.MAX_VERSION;
        }
        return Version.createOSGi((int)version.getMajor(), (int)version.getMinor(), (int)version.getMicro(), (String)version.getQualifier());
    }

    private static VersionRange fromOSGiVersionRange(org.eclipse.osgi.service.resolver.VersionRange range) {
        if (range.equals((Object)org.eclipse.osgi.service.resolver.VersionRange.emptyRange)) {
            return VersionRange.emptyRange;
        }
        return new VersionRange(P2Utils.fromOSGiVersion(range.getMinimum()), range.getIncludeMinimum(), P2Utils.fromOSGiVersion(range.getRight()), range.getIncludeMaximum());
    }
}

