/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.RepeatingFilePasswordProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;

public class PasswordProviderWrapper
implements RepeatingFilePasswordProvider {
    private final KeyPasswordProvider delegate;
    private Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();

    public PasswordProviderWrapper(@NonNull KeyPasswordProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setAttempts(int numberOfPasswordPrompts) {
        this.delegate.setAttempts(numberOfPasswordPrompts);
    }

    @Override
    public int getAttempts() {
        return this.delegate.getAttempts();
    }

    public String getPassword(SessionContext session, NamedResource resource, int attemptIndex) throws IOException {
        String key = resource.getName();
        int attempt = this.counts.computeIfAbsent(key, k -> new AtomicInteger()).get();
        char[] passphrase = this.delegate.getPassphrase(this.toUri(key), attempt);
        if (passphrase == null) {
            return null;
        }
        try {
            String string = new String(passphrase);
            return string;
        }
        finally {
            Arrays.fill(passphrase, '\u0000');
        }
    }

    public FilePasswordProvider.ResourceDecodeResult handleDecodeAttemptResult(SessionContext session, NamedResource resource, int retryIndex, String password, Exception err) throws IOException, GeneralSecurityException {
        String key = resource.getName();
        AtomicInteger count = this.counts.get(key);
        int numberOfAttempts = count == null ? 0 : count.incrementAndGet();
        FilePasswordProvider.ResourceDecodeResult result = null;
        try {
            result = this.delegate.keyLoaded(this.toUri(key), numberOfAttempts, err) ? FilePasswordProvider.ResourceDecodeResult.RETRY : FilePasswordProvider.ResourceDecodeResult.TERMINATE;
        }
        finally {
            if (result != FilePasswordProvider.ResourceDecodeResult.RETRY) {
                this.counts.remove(key);
            }
        }
        return result;
    }

    private URIish toUri(String resourceKey) {
        try {
            return new URIish(resourceKey);
        }
        catch (URISyntaxException e) {
            return new URIish().setPath(resourceKey);
        }
    }
}

