/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.operations;

import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.operations.CreateInstanceOperation;
import org.eclipse.emf.diffmerge.patterns.core.operations.InstanceOperation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;

public class ApplyTemplatePatternOperation
extends CreateInstanceOperation {
    private final String _namingRule;
    private final int _index;
    private final boolean _unfold;
    private final int _multiplicity;

    public ApplyTemplatePatternOperation(IPatternApplication application_p, boolean unfold_p, String namingRule_p, int index_p, int multiplicity_p, Object patternSideContext_p, Object modelSideContext_p) {
        super(application_p, patternSideContext_p, modelSideContext_p);
        this._namingRule = namingRule_p;
        this._index = index_p;
        this._unfold = unfold_p;
        this._multiplicity = multiplicity_p;
    }

    protected IPatternInstance run() {
        InstanceOperation unfoldOperation;
        IEvaluationStatus unfoldStatus;
        IPatternInstance result = super.run();
        if (result != null && result.getPatternData() instanceof TemplatePatternData) {
            TemplatePatternData data = (TemplatePatternData)result.getPatternData();
            String finalNamingRule = this._namingRule;
            if (finalNamingRule != null) {
                finalNamingRule = NamingUtil.substituteIndex(finalNamingRule, this._index);
            }
            data.setNamingRule(finalNamingRule);
            data.setMultiplicity(this._multiplicity);
        }
        if (result != null && this._unfold && (unfoldStatus = (IEvaluationStatus)this.call((AbstractModelOperation)(unfoldOperation = new InstanceOperation(result, InstanceOperation.InstanceOperationKind.UNFOLD, null, this.getTargetContext(), this.getSourceContext())))) instanceof IModelTransformationStatus && ((IModelTransformationStatus)unfoldStatus).isAborted()) {
            this.abort();
        }
        return result;
    }
}

