/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.util.FS;

public class FileSnapshot {
    public static final long UNKNOWN_SIZE = -1L;
    private static final Object MISSING_FILEKEY = new Object();
    public static final FileSnapshot DIRTY = new FileSnapshot(-1L, -1L, -1L, Duration.ZERO, MISSING_FILEKEY);
    public static final FileSnapshot MISSING_FILE = new FileSnapshot(0L, 0L, 0L, Duration.ZERO, MISSING_FILEKEY){

        @Override
        public boolean isModified(File path) {
            return FS.DETECTED.exists(path);
        }
    };
    private final long lastModified;
    private volatile long lastRead;
    private boolean cannotBeRacilyClean;
    private final long size;
    private Duration fsTimestampResolution;
    private final Object fileKey;
    private boolean sizeChanged;
    private boolean fileKeyChanged;
    private boolean lastModifiedChanged;
    private boolean wasRacyClean;

    public static FileSnapshot save(File path) {
        return new FileSnapshot(path);
    }

    private static Object getFileKey(BasicFileAttributes fileAttributes) {
        Object fileKey = fileAttributes.fileKey();
        return fileKey == null ? MISSING_FILEKEY : fileKey;
    }

    public static FileSnapshot save(long modified) {
        long read = System.currentTimeMillis();
        return new FileSnapshot(read, modified, -1L, Duration.ZERO, MISSING_FILEKEY);
    }

    protected FileSnapshot(File path) {
        this.lastRead = System.currentTimeMillis();
        this.fsTimestampResolution = FS.getFsTimerResolution(path.toPath().getParent());
        BasicFileAttributes fileAttributes = null;
        try {
            fileAttributes = FS.DETECTED.fileAttributes(path);
        }
        catch (IOException e) {
            this.lastModified = path.lastModified();
            this.size = path.length();
            this.fileKey = MISSING_FILEKEY;
            return;
        }
        this.lastModified = fileAttributes.lastModifiedTime().toMillis();
        this.size = fileAttributes.size();
        this.fileKey = FileSnapshot.getFileKey(fileAttributes);
    }

    private FileSnapshot(long read, long modified, long size, @NonNull Duration fsTimestampResolution, @NonNull Object fileKey) {
        this.lastRead = read;
        this.lastModified = modified;
        this.fsTimestampResolution = fsTimestampResolution;
        this.size = size;
        this.fileKey = fileKey;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long size() {
        return this.size;
    }

    public boolean isModified(File path) {
        Object currFileKey;
        long currSize;
        long currLastModified;
        try {
            BasicFileAttributes fileAttributes = FS.DETECTED.fileAttributes(path);
            currLastModified = fileAttributes.lastModifiedTime().toMillis();
            currSize = fileAttributes.size();
            currFileKey = FileSnapshot.getFileKey(fileAttributes);
        }
        catch (IOException e) {
            currLastModified = path.lastModified();
            currSize = path.length();
            currFileKey = MISSING_FILEKEY;
        }
        this.sizeChanged = this.isSizeChanged(currSize);
        if (this.sizeChanged) {
            return true;
        }
        this.fileKeyChanged = this.isFileKeyChanged(currFileKey);
        if (this.fileKeyChanged) {
            return true;
        }
        this.lastModifiedChanged = this.isModified(currLastModified);
        return this.lastModifiedChanged;
    }

    public void setClean(FileSnapshot other) {
        long now = other.lastRead;
        if (!this.isRacyClean(now)) {
            this.cannotBeRacilyClean = true;
        }
        this.lastRead = now;
    }

    public void waitUntilNotRacy() throws InterruptedException {
        while (this.isRacyClean(System.currentTimeMillis())) {
            TimeUnit.NANOSECONDS.sleep((this.fsTimestampResolution.toNanos() + 1L) * 11L / 10L);
        }
    }

    public boolean equals(FileSnapshot other) {
        return this.lastModified == other.lastModified && this.size == other.size && Objects.equals(this.fileKey, other.fileKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSnapshot)) {
            return false;
        }
        FileSnapshot other = (FileSnapshot)obj;
        return this.equals(other);
    }

    public int hashCode() {
        return Objects.hash(this.lastModified, this.size, this.fileKey);
    }

    boolean wasSizeChanged() {
        return this.sizeChanged;
    }

    boolean wasFileKeyChanged() {
        return this.fileKeyChanged;
    }

    boolean wasLastModifiedChanged() {
        return this.lastModifiedChanged;
    }

    boolean wasLastModifiedRacilyClean() {
        return this.wasRacyClean;
    }

    public String toString() {
        if (this == DIRTY) {
            return "DIRTY";
        }
        if (this == MISSING_FILE) {
            return "MISSING_FILE";
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        return "FileSnapshot[modified: " + f.format(new Date(this.lastModified)) + ", read: " + f.format(new Date(this.lastRead)) + ", size:" + this.size + ", fileKey: " + this.fileKey + "]";
    }

    private boolean isRacyClean(long read) {
        long racyNanos = (this.fsTimestampResolution.toNanos() + 1L) * 11L / 10L;
        this.wasRacyClean = (read - this.lastModified) * 1000000L <= racyNanos;
        return this.wasRacyClean;
    }

    private boolean isModified(long currLastModified) {
        boolean bl = this.lastModifiedChanged = this.lastModified != currLastModified;
        if (this.lastModifiedChanged) {
            return true;
        }
        if (this.cannotBeRacilyClean) {
            return false;
        }
        return this.isRacyClean(this.lastRead);
    }

    private boolean isFileKeyChanged(Object currFileKey) {
        return currFileKey != MISSING_FILEKEY && !currFileKey.equals(this.fileKey);
    }

    private boolean isSizeChanged(long currSize) {
        return currSize != -1L && currSize != this.size;
    }

    /* synthetic */ FileSnapshot(long l, long l2, long l3, Duration duration, Object object, FileSnapshot fileSnapshot) {
        this(l, l2, l3, duration, object);
    }
}

