/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.PositionTracker;

public class EditorAccessHighlighter
extends Highlighter {
    private ISearchEditorAccess fEditorAcess;
    private Map<Match, Annotation> fMatchesToAnnotations;

    public EditorAccessHighlighter(ISearchEditorAccess editorAccess) {
        this.fEditorAcess = editorAccess;
        this.fMatchesToAnnotations = new HashMap<Match, Annotation>();
    }

    @Override
    public void addHighlights(Match[] matches) {
        HashMap<IAnnotationModel, HashMap<Annotation, Position>> mapsByAnnotationModel = new HashMap<IAnnotationModel, HashMap<Annotation, Position>>();
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            int offset = match.getOffset();
            int length = match.getLength();
            if (offset >= 0 && length >= 0) {
                try {
                    Map<Annotation, Position> map;
                    Position position = this.createPosition(match);
                    if (position != null && (map = this.getMap(mapsByAnnotationModel, match)) != null) {
                        Annotation annotation = match.isFiltered() ? new Annotation("org.eclipse.search.filteredResults", true, null) : new Annotation("org.eclipse.search.results", true, null);
                        this.fMatchesToAnnotations.put(match, annotation);
                        map.put(annotation, position);
                    }
                }
                catch (BadLocationException e) {
                    SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.EditorAccessHighlighter_error_badLocation, (Throwable)e));
                }
            }
            ++n2;
        }
        for (Map.Entry entry : mapsByAnnotationModel.entrySet()) {
            this.addAnnotations((IAnnotationModel)entry.getKey(), (Map)entry.getValue());
        }
    }

    private Position createPosition(Match match) throws BadLocationException {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        position = position == null ? new Position(match.getOffset(), match.getLength()) : new Position(position.getOffset(), position.getLength());
        if (match.getBaseUnit() == 1) {
            IDocument doc = this.fEditorAcess.getDocument(match);
            if (doc != null) {
                position = PositionTracker.convertToCharacterPosition(position, doc);
            } else {
                SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.AnnotationHighlighter_error_noDocument, null));
                return null;
            }
        }
        return position;
    }

    private Map<Annotation, Position> getMap(Map<IAnnotationModel, HashMap<Annotation, Position>> mapsByAnnotationModel, Match match) {
        IAnnotationModel model = this.fEditorAcess.getAnnotationModel(match);
        if (model == null) {
            return null;
        }
        HashMap<Object, Object> map = mapsByAnnotationModel.get(model);
        if (map == null) {
            map = new HashMap();
            mapsByAnnotationModel.put(model, map);
        }
        return map;
    }

    private Set<Annotation> getSet(Map<IAnnotationModel, HashSet<Annotation>> setsByAnnotationModel, Match match) {
        IAnnotationModel model = this.fEditorAcess.getAnnotationModel(match);
        if (model == null) {
            return null;
        }
        HashSet<Object> set = setsByAnnotationModel.get(model);
        if (set == null) {
            set = new HashSet();
            setsByAnnotationModel.put(model, set);
        }
        return set;
    }

    @Override
    public void removeHighlights(Match[] matches) {
        HashMap<IAnnotationModel, HashSet<Annotation>> setsByAnnotationModel = new HashMap<IAnnotationModel, HashSet<Annotation>>();
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Set<Annotation> annotations;
            Match match = matchArray[n2];
            Annotation annotation = this.fMatchesToAnnotations.remove(match);
            if (annotation != null && (annotations = this.getSet(setsByAnnotationModel, match)) != null) {
                annotations.add(annotation);
            }
            ++n2;
        }
        for (Map.Entry entry : setsByAnnotationModel.entrySet()) {
            this.removeAnnotations((IAnnotationModel)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void addAnnotations(IAnnotationModel model, Map<Annotation, Position> annotationToPositionMap) {
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)model;
            ame.replaceAnnotations(new Annotation[0], annotationToPositionMap);
        } else {
            for (Map.Entry<Annotation, Position> entry : annotationToPositionMap.entrySet()) {
                model.addAnnotation(entry.getKey(), entry.getValue());
            }
        }
    }

    private void removeAnnotations(IAnnotationModel model, Set<Annotation> annotations) {
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)model;
            Annotation[] annotationArray = new Annotation[annotations.size()];
            ame.replaceAnnotations(annotations.toArray(annotationArray), Collections.emptyMap());
        } else {
            for (Annotation element : annotations) {
                model.removeAnnotation(element);
            }
        }
    }

    @Override
    public void removeAll() {
        Set<Match> matchSet = this.fMatchesToAnnotations.keySet();
        Match[] matches = new Match[matchSet.size()];
        this.removeHighlights(matchSet.toArray(matches));
    }

    @Override
    protected void handleContentReplaced(IFileBuffer buffer) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        Object document = null;
        ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
        for (Match match : this.fMatchesToAnnotations.keySet()) {
            document = this.fEditorAcess.getDocument(match);
            if (document != null) break;
        }
        if (document != null && document.equals(textBuffer.getDocument())) {
            Match[] matches = new Match[this.fMatchesToAnnotations.keySet().size()];
            this.fMatchesToAnnotations.keySet().toArray(matches);
            this.removeAll();
            this.addHighlights(matches);
        }
    }
}

