/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;

public class BranchOperation
implements IEGitOperation {
    private final String target;
    private Repository[] repositories;
    @NonNull
    private Map<Repository, CheckoutResult> results = new HashMap<Repository, CheckoutResult>();
    private boolean delete;

    public BranchOperation(Repository repository, String target) {
        this(repository, target, true);
    }

    public BranchOperation(Repository repository, String target, boolean delete) {
        this(new Repository[]{repository}, target, delete);
    }

    public BranchOperation(Repository[] repositories, String target, boolean delete) {
        this.repositories = repositories;
        this.target = target;
        this.delete = delete;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)4);
                Repository[] repositoryArray = BranchOperation.this.repositories;
                int n = repositoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Repository repository = repositoryArray[n2];
                    CheckoutResult result = this.checkoutRepository(repository, progress);
                    if (result.getStatus() == CheckoutResult.Status.NONDELETED) {
                        BranchOperation.this.retryDelete(repository, result.getUndeletedList());
                    }
                    BranchOperation.this.results.put(repository, result);
                    ++n2;
                }
                this.refreshAffectedProjects(progress);
            }

            public CheckoutResult checkoutRepository(Repository repo, SubMonitor progress) throws CoreException {
                this.closeProjectsMissingAfterCheckout(repo, progress);
                Throwable throwable = null;
                Object var4_5 = null;
                try (Git git = new Git(repo);){
                    CheckoutCommand co = git.checkout().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(1)));
                    co.setName(BranchOperation.this.target);
                    try {
                        co.call();
                    }
                    catch (GitAPIException | JGitInternalException throwable2) {
                        // empty catch block
                    }
                    return co.getResult();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }

            private void closeProjectsMissingAfterCheckout(Repository repo, SubMonitor progress) throws CoreException {
                IProject[] missing = BranchOperation.this.getMissingProjects(repo, BranchOperation.this.target);
                progress.setTaskName(NLS.bind((String)CoreText.BranchOperation_performingBranch, (Object)BranchOperation.this.target));
                progress.setWorkRemaining(missing.length > 0 ? 4 : 3);
                if (missing.length > 0) {
                    SubMonitor closeMonitor = progress.newChild(1);
                    closeMonitor.setWorkRemaining(missing.length);
                    IProject[] iProjectArray = missing;
                    int n = missing.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        closeMonitor.subTask(MessageFormat.format(CoreText.BranchOperation_closingMissingProject, project.getName()));
                        project.close((IProgressMonitor)closeMonitor.newChild(1));
                        ++n2;
                    }
                }
            }

            private void refreshAffectedProjects(SubMonitor progress) throws CoreException {
                IProject[] refreshProjects = (IProject[])BranchOperation.this.results.entrySet().stream().map(this::getAffectedProjects).flatMap(arr -> Stream.of(arr)).distinct().toArray(IProject[]::new);
                ProjectUtil.refreshValidProjects(refreshProjects, BranchOperation.this.delete, (IProgressMonitor)progress.newChild(1));
            }

            private IProject[] getAffectedProjects(Map.Entry<Repository, CheckoutResult> entry) {
                CheckoutResult result = entry.getValue();
                if (result.getStatus() != CheckoutResult.Status.OK && result.getStatus() != CheckoutResult.Status.NONDELETED) {
                    return new IProject[0];
                }
                Repository repo = entry.getKey();
                ArrayList<String> pathsToHandle = new ArrayList<String>();
                pathsToHandle.addAll(result.getModifiedList());
                pathsToHandle.addAll(result.getRemovedList());
                pathsToHandle.addAll(result.getConflictList());
                IProject[] refreshProjects = ProjectUtil.getProjectsContaining(repo, pathsToHandle);
                return refreshProjects;
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(Arrays.asList(this.repositories));
    }

    @NonNull
    public Map<Repository, CheckoutResult> getResults() {
        return this.results;
    }

    public CheckoutResult getResult(Repository repo) {
        return this.results.get(repo);
    }

    void retryDelete(Repository repo, List<String> pathList) {
        long startTime = System.currentTimeMillis();
        for (String path : pathList) {
            if (System.currentTimeMillis() - startTime > 1000L) break;
            File fileToDelete = new File(repo.getWorkTree(), path);
            if (!fileToDelete.exists()) continue;
            try {
                if (fileToDelete.isFile()) continue;
                FileUtils.delete((File)fileToDelete, (int)2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IProject[] getMissingProjects(Repository repository, String branch) throws CoreException {
        ObjectId currentTreeId;
        ObjectId targetTreeId;
        IProject[] openProjects = ProjectUtil.getValidOpenProjects(repository);
        if (this.delete || openProjects.length == 0) {
            return new IProject[0];
        }
        try {
            targetTreeId = repository.resolve(String.valueOf(branch) + "^{tree}");
            currentTreeId = repository.resolve("HEAD^{tree}");
        }
        catch (IOException e) {
            return new IProject[0];
        }
        if (targetTreeId == null || currentTreeId == null) {
            return new IProject[0];
        }
        HashMap<File, IProject> locations = new HashMap<File, IProject>();
        IProject[] iProjectArray = openProjects;
        int n = openProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath location = project.getLocation();
            if (location != null) {
                location = location.append(".project");
                locations.put(location.toFile(), project);
            }
            ++n2;
        }
        ArrayList<IProject> toBeClosed = new ArrayList<IProject>();
        File root = repository.getWorkTree();
        try {
            Throwable throwable = null;
            iProjectArray = null;
            try (TreeWalk walk = new TreeWalk(repository);){
                walk.addTree((AnyObjectId)targetTreeId);
                walk.addTree((AnyObjectId)currentTreeId);
                walk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                walk.setRecursive(true);
                walk.setFilter(AndTreeFilter.create((TreeFilter)PathSuffixFilter.create((String)".project"), (TreeFilter)TreeFilter.ANY_DIFF));
                while (walk.next()) {
                    IProject project;
                    AbstractTreeIterator targetIter = walk.getTree(0, AbstractTreeIterator.class);
                    if (targetIter != null) continue;
                    AbstractTreeIterator currentIter = walk.getTree(1, AbstractTreeIterator.class);
                    AbstractTreeIterator workingIter = walk.getTree(2, AbstractTreeIterator.class);
                    if (currentIter == null || workingIter == null || (project = (IProject)locations.get(new File(root, walk.getPathString()))) == null) continue;
                    toBeClosed.add(project);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new IProject[0];
        }
        return toBeClosed.toArray(new IProject[0]);
    }
}

