/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewPage;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchViewTreeNode;
import org.eclipse.xtext.ui.editor.findrefs.TreeViewerNavigator;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

public interface ReferenceSearchViewPageActions {

    public static class CollapseAll
    extends Action {
        private ReferenceSearchViewPage page;

        public CollapseAll(ReferenceSearchViewPage page) {
            super(Messages.ReferenceSearchViewPageActions_collapseAll);
            this.setImageDescriptor(XtextPluginImages.DESC_COLLAPSE_ALL);
            this.page = page;
        }

        public void run() {
            this.page.getViewer().collapseAll();
        }
    }

    public static class Copy
    extends Action {
        private ReferenceSearchViewPage page;

        public Copy(ReferenceSearchViewPage page) {
            super(Messages.ReferenceSearchViewPageActions_copy);
            ImageDescriptor img = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
            this.setImageDescriptor(img);
            this.setAccelerator(4194403);
            this.page = page;
        }

        public void run() {
            TreeViewer viewer = this.page.getViewer();
            Clipboard clipboard = new Clipboard(viewer.getControl().getDisplay());
            ITreeSelection selection = this.page.getViewer().getStructuredSelection();
            String data = selection.toList().stream().map(sel -> this.page.getLabelProvider().getText(sel)).collect(Collectors.joining(System.lineSeparator()));
            clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public static class ExpandAll
    extends Action {
        private ReferenceSearchViewPage page;

        public ExpandAll(ReferenceSearchViewPage page) {
            super(Messages.ReferenceSearchViewPageActions_expandAll);
            this.setImageDescriptor(XtextPluginImages.DESC_EXPAND_ALL);
            this.page = page;
        }

        public void run() {
            this.page.getViewer().expandAll();
        }
    }

    public static class RemoveSelectedMatchesAction
    extends Action {
        private ReferenceSearchViewPage page;

        public RemoveSelectedMatchesAction(ReferenceSearchViewPage page) {
            super(Messages.ReferenceSearchViewPageActions_removeSelectedMatches);
            ImageDescriptor img = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE");
            this.setImageDescriptor(img);
            this.setAccelerator(127);
            this.page = page;
        }

        public void run() {
            TreeViewer viewer = this.page.getViewer();
            ITreeSelection selection = viewer.getStructuredSelection();
            Stream<Object> nodeStream = selection.toList().stream().filter(ReferenceSearchViewTreeNode.class::isInstance).map(ReferenceSearchViewTreeNode.class::cast);
            this.page.getContentProvider().remove((ReferenceSearchViewTreeNode[])nodeStream.toArray(ReferenceSearchViewTreeNode[]::new));
            viewer.refresh();
        }
    }

    public static class ShowNext
    extends Action {
        private ReferenceSearchViewPage page;

        public ShowNext(ReferenceSearchViewPage page) {
            super(Messages.ReferenceSearchViewPageActions_showNextMatch);
            this.setImageDescriptor(XtextPluginImages.DESC_SEARCH_NEXT);
            this.page = page;
        }

        public void run() {
            new TreeViewerNavigator(this.page).navigateNext(true);
        }
    }

    public static class ShowPrevious
    extends Action {
        private ReferenceSearchViewPage page;

        public ShowPrevious(ReferenceSearchViewPage page) {
            super(Messages.ReferenceSearchViewPageActions_showPreviousMatch);
            this.setImageDescriptor(XtextPluginImages.DESC_SEARCH_PREVIOUS);
            this.page = page;
        }

        public void run() {
            new TreeViewerNavigator(this.page).navigateNext(false);
        }
    }
}

