/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.AbstractStepContainer;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Chain;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Item;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Job;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Step;
import org.eclipse.egf.portfolio.eclipse.build.buildfile.AntParameter;
import org.eclipse.egf.portfolio.eclipse.build.buildfile.FileStep;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.BuildstepPackage;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.PatternBuildLocation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationHelper {
    private static final String FEATURE_SUFFIX = ".feature";
    private static final String SOURCE_SUFFIX = ".source";

    public boolean needPublish(EObject eObject) {
        boolean result = false;
        result = result || this.containsClass(eObject, BuildstepPackage.eINSTANCE.getPublishStep());
        result = result || this.containsClass(eObject, BuildstepPackage.eINSTANCE.getAggregateStep());
        result = result || this.containsClass(eObject, BuildstepPackage.eINSTANCE.getInstallStep());
        return result;
    }

    public boolean needJavadocPublish(EObject eObject) {
        boolean result = false;
        result = result || this.containsClass(eObject, BuildstepPackage.eINSTANCE.getJavadocStep());
        return result;
    }

    public boolean hasBinaryBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getBinaryBuildLocation());
    }

    public boolean hasTargetPlatformBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getTargetPlatformBuildLocation());
    }

    public boolean hasRunningPlatformBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getRunningPlatformBuildLocation());
    }

    public boolean hasInstallStepBuildLocation(EObject eObject) {
        return this.containsClass(eObject, BuildstepPackage.eINSTANCE.getInstallStepBuildLocation());
    }

    private boolean containsClass(EObject eObject, EClass eClass) {
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EClass currentEClass = ((EObject)eAllContents.next()).eClass();
            if (!eClass.equals(currentEClass) && !currentEClass.getESuperTypes().contains((Object)eClass)) continue;
            return true;
        }
        return false;
    }

    public Job getNextChainJob(Job job2) {
        Chain chain2 = (Chain)job2.eContainer();
        if (chain2 == null) {
            return null;
        }
        EList eContents = chain2.eContents();
        int i = eContents.indexOf((Object)job2) + 1;
        while (i < eContents.size()) {
            EObject next = (EObject)eContents.get(i);
            if (next instanceof Job) {
                return (Job)next;
            }
            ++i;
        }
        return null;
    }

    public String getJobName(PatternContext context, Job job2) {
        boolean prefixJobNameWithChainName = (Boolean)context.getValue("prefixJobNameWithChainName");
        Chain chain2 = (Chain)job2.eContainer();
        if (prefixJobNameWithChainName && chain2 != null) {
            return String.valueOf(chain2.getName()) + "_" + job2.getName();
        }
        return job2.getName();
    }

    public String getStringIfNotNull(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    public String getPatternString(PatternBuildLocation buildLocation) {
        String patternString = buildLocation.getPattern();
        if (patternString == null) {
            return "";
        }
        patternString = patternString.replaceAll("\\.", "\\\\.");
        patternString = patternString.replaceAll("\\?", ".");
        patternString = patternString.replaceAll("\\*", ".*");
        return "pattern=\"^" + patternString + "\"";
    }

    public String getNameOrGeneratedIdString(EObject eObject) {
        StringBuilder result = new StringBuilder();
        while (eObject != null) {
            EObject eContainer = eObject.eContainer();
            String nameOrGeneratedId = null;
            if (eObject instanceof Step) {
                nameOrGeneratedId = ((Step)eObject).getName();
            }
            if (eObject instanceof Item) {
                nameOrGeneratedId = ((Item)eObject).getName();
            }
            if (nameOrGeneratedId == null || nameOrGeneratedId.trim().length() == 0) {
                if (eContainer instanceof AbstractStepContainer) {
                    AbstractStepContainer abstractStepContainer = (AbstractStepContainer)eContainer;
                    nameOrGeneratedId = Integer.toString(abstractStepContainer.getSteps().indexOf((Object)eObject) + 1);
                } else if (eContainer != null) {
                    nameOrGeneratedId = Integer.toString(eContainer.eContents().indexOf((Object)eObject) + 1);
                }
                nameOrGeneratedId = String.valueOf(eObject.eClass().getName()) + "_" + nameOrGeneratedId;
            }
            if (nameOrGeneratedId != null) {
                if (result.length() > 0) {
                    result.insert(0, '_');
                }
                result.insert(0, nameOrGeneratedId.replace(' ', '_').replace('\\', '_').replace('/', '_'));
            }
            if (!((eObject = eContainer) instanceof Job) && !(eObject instanceof Chain)) continue;
            eObject = null;
        }
        return result.toString();
    }

    public String createSourceFeatureId(String originalId) {
        StringBuilder sourceIdBld = new StringBuilder();
        if (originalId.endsWith(FEATURE_SUFFIX)) {
            sourceIdBld.append(originalId, 0, originalId.length() - FEATURE_SUFFIX.length());
            sourceIdBld.append(SOURCE_SUFFIX);
            sourceIdBld.append(FEATURE_SUFFIX);
        } else {
            sourceIdBld.append(originalId);
            sourceIdBld.append(SOURCE_SUFFIX);
        }
        return sourceIdBld.toString();
    }

    public Job getJob(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container instanceof Job) {
            return (Job)container;
        }
        if (container != null) {
            return this.getJob(container);
        }
        return null;
    }

    public String getPublishPath(PatternContext context, EObject targetEObject, EObject sourceEObject) {
        if (this.getJob(sourceEObject) == this.getJob(targetEObject)) {
            return "${publish}/";
        }
        return "${build.root}/../../" + this.getJobName(context, this.getJob(targetEObject)) + "/workspace/result/publish/";
    }

    public List<Step> getAllSteps(Job job2) {
        ArrayList<Step> result = new ArrayList<Step>();
        TreeIterator iterator = job2.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof Step)) continue;
            result.add((Step)eObject);
        }
        return result;
    }

    public String getAdditionalParametersString(FileStep fileStep) {
        StringBuilder builder = new StringBuilder();
        for (AntParameter antParameter : fileStep.getAdditionalParameters()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(antParameter.getKey());
            builder.append("=\"");
            builder.append(antParameter.getValue());
            builder.append("\"");
        }
        return builder.toString();
    }
}

