/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AppContext {
    public static AppContext getContext() {
        return AppContextHolder.INSTANCE;
    }

    public abstract String getString(String var1);

    public abstract <T> T getBean(Class<T> var1);

    public abstract void setString(String var1, String var2);

    public abstract void setBean(Object var1);

    public abstract PrintWriter getLogWriter();

    public abstract void setLogWriter(PrintWriter var1);

    public abstract AppContext clean();

    public abstract Classpath getInputClasspath();

    public abstract void setInputClasspath(Classpath var1);

    public abstract void setClassLoader(ClassDescriptionLoader var1);

    public abstract ClassDescriptionLoader getClassLoader();

    private static class AppContextImpl
    extends AppContext {
        private ConcurrentHashMap<String, String> strings = new ConcurrentHashMap();
        private ConcurrentHashMap<Class, Object> beans = new ConcurrentHashMap();
        private PrintWriter log;
        private Classpath cp;
        private ClassDescriptionLoader loader;

        private AppContextImpl() {
        }

        @Override
        public void setString(String id, String value) {
            this.strings.put(id, value);
        }

        @Override
        public void setBean(Object bean) {
            this.beans.put(bean.getClass(), bean);
        }

        @Override
        public PrintWriter getLogWriter() {
            return this.log;
        }

        @Override
        public void setLogWriter(PrintWriter pw) {
            this.log = pw;
        }

        @Override
        public String getString(String id) {
            return this.strings.get(id);
        }

        @Override
        public synchronized <T> T getBean(Class<T> clz) {
            if (!this.beans.containsKey(clz)) {
                Object beanObj = null;
                try {
                    beanObj = clz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                this.beans.put(clz, beanObj);
            }
            return (T)this.beans.get(clz);
        }

        @Override
        public synchronized AppContext clean() {
            this.strings.clear();
            this.beans.clear();
            this.log = null;
            this.cp = null;
            return this;
        }

        @Override
        public Classpath getInputClasspath() {
            return this.cp;
        }

        @Override
        public void setInputClasspath(Classpath cp) {
            this.cp = cp;
        }

        @Override
        public void setClassLoader(ClassDescriptionLoader loader) {
            this.loader = loader;
        }

        @Override
        public ClassDescriptionLoader getClassLoader() {
            return this.loader;
        }
    }

    private static class AppContextHolder {
        public static final AppContext INSTANCE = new AppContextImpl();

        private AppContextHolder() {
        }
    }
}

