/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JobAttributeRestartTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;
    private long TIMEOUT = 5000L;

    @Test
    public void testJobAttributeRestartableTrue() throws Exception {
        String METHOD = "testJobAttributeRestartableTrue";
        try {
            Reporter.log((String)"starting job");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            jobParams.put("execution.number", "1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_attributes_restart_true_test", jobParams);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job failed ", BatchStatus.FAILED, jobExec.getBatchStatus());
            Reporter.log((String)"restarting job");
            Properties restartParams = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            restartParams.put("execution.number", "2");
            TCKJobExecutionWrapper newJobExec = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartParams);
            Reporter.log((String)("Job Status = " + newJobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, newJobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            JobAttributeRestartTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

