/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.listener.AbstractJobListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Logger;

@Named
public class ThreadTrackingJobListener
extends AbstractJobListener {
    private static final Logger logger = Logger.getLogger(ThreadTrackingJobListener.class.getName());
    public static final String GOOD_EXIT = "GOOD_EXIT";
    @Inject
    private JobContext jobCtx = null;

    public void beforeJob() throws Exception {
        this.jobCtx.setTransientUserData((Object)Thread.currentThread());
    }

    public void afterJob() throws Exception {
        Thread t = (Thread)this.jobCtx.getTransientUserData();
        if (t != null) {
            logger.warning("Failing test in current thread:" + Thread.currentThread());
            throw new IllegalStateException("Failing test in current thread:" + Thread.currentThread());
        }
        this.jobCtx.setExitStatus(GOOD_EXIT);
    }
}

