/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.cdi;

import jakarta.batch.api.Batchlet;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.StringWriter;
import java.util.Properties;

@Dependent
@Named(value="CDIDependentScopedBatchletContexts")
public class DependentScopedBatchletContexts
implements Batchlet {
    @Inject
    JobContext jf;
    JobContext jc;
    JobContext jm;
    @Inject
    StepContext sf;
    StepContext sc;
    StepContext sm;

    @Inject
    DependentScopedBatchletContexts(JobContext jc, StepContext sc) {
        this.jc = jc;
        this.sc = sc;
    }

    @Inject
    public void setMethod1(JobContext jm) {
        this.jm = jm;
    }

    @Inject
    public void setMethod2(StepContext sm) {
        this.sm = sm;
    }

    public String process() throws Exception {
        this.updateJobExitStatus(this.jf);
        this.updateJobExitStatus(this.jc);
        this.updateJobExitStatus(this.jm);
        this.updateStepExitStatus(this.sf);
        this.updateStepExitStatus(this.sc);
        this.updateStepExitStatus(this.sm);
        return this.sm.getExitStatus();
    }

    private void updateJobExitStatus(JobContext jobCtx) {
        String es = jobCtx.getExitStatus();
        es = es == null ? "" : es;
        StringBuilder sb = new StringBuilder(es);
        sb.append(jobCtx.getExecutionId()).append(":");
        jobCtx.setExitStatus(sb.toString());
    }

    private void updateStepExitStatus(StepContext stepCtx) {
        String es = stepCtx.getExitStatus();
        es = es == null ? "" : es;
        StringBuilder sb = new StringBuilder(es);
        sb.append(stepCtx.getStepExecutionId()).append(":");
        stepCtx.setExitStatus(sb.toString());
    }

    public void stop() throws Exception {
    }

    public static String getPropertyAsString(Properties prop) throws Exception {
        StringWriter writer = new StringWriter();
        prop.store(writer, "");
        return writer.getBuffer().toString();
    }
}

