/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.services;

import java.io.File;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.mylyn.docs.intent.client.ui.preferences.IntentPreferenceService;
import org.eclipse.mylyn.docs.intent.collab.common.query.TraceabilityInformationsQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ExternalContentReference;
import org.eclipse.mylyn.docs.intent.exporter.services.CopyImageUtils;
import org.eclipse.mylyn.docs.intent.markup.gen.services.ImageServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentAcceleoServices {
    private static File outputFolder;
    private static String intentDocumentTitle;
    private static RepositoryAdapter repositoryAdapter;
    private static TraceabilityIndex traceabilityIndex;
    private static boolean shouldShowTableOfContents;
    private static ComposedAdapterFactory adapterFactory;

    private IntentAcceleoServices() {
    }

    public static String getHeaderSizeForSection(String sectionID) {
        return String.valueOf(sectionID.split("_").length);
    }

    public static String getDocumentTitle(EObject any) {
        return intentDocumentTitle;
    }

    public static String getQualifiedImageID(EObject any) {
        return CopyImageUtils.copyImageAndGetImageID(any, repositoryAdapter, outputFolder);
    }

    public static IntentSection getContainingSection(EObject any) {
        EObject container = any;
        if (any instanceof UnitInstruction) {
            while (container != null && !(container instanceof IntentSection)) {
                container = container.eContainer();
            }
        }
        if (container instanceof IntentSection) {
            return (IntentSection)container;
        }
        return null;
    }

    public static Collection<ContributionInstruction> getAllContributions(UnitInstruction instruction) {
        return new TraceabilityInformationsQuery(repositoryAdapter).getAllRelatedContributions(instruction);
    }

    public static TraceabilityIndex getTraceabilityIndex(RepositoryAdapter currentRepositoryAdapter) {
        if (traceabilityIndex == null) {
            traceabilityIndex = new TraceabilityInformationsQuery(currentRepositoryAdapter).getOrCreateTraceabilityIndex();
        }
        return traceabilityIndex;
    }

    public static boolean shouldDisplayExternalRefInline() {
        return IntentPreferenceService.getBoolean((String)"org.eclipse.mylyn.docs.intent.client.ui.preferences.export_display_references_inline");
    }

    public static String getName(ExternalContentReference ref) {
        Adapter labelProvider;
        String displayedName = ref.getUri().toString();
        if (ref.getExternalContent() != null && (labelProvider = IntentAcceleoServices.getAdapterFactory().adapt((Notifier)ref.getExternalContent(), IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            displayedName = ((IItemLabelProvider)labelProvider).getText((Object)ref.getExternalContent());
        }
        return displayedName;
    }

    public static String getIndex(IntentStructuredElement structuredElement) {
        String index = "";
        if (structuredElement.getCompleteLevel() != null) {
            index = structuredElement.getCompleteLevel().replace(".", "_");
        }
        return index;
    }

    public static boolean shouldShowTableOfContents() {
        return shouldShowTableOfContents;
    }

    public static void initialize(String documentTitle, File generationOutputFolder, boolean showTableOfContents, RepositoryAdapter adapter) {
        intentDocumentTitle = documentTitle;
        outputFolder = generationOutputFolder;
        shouldShowTableOfContents = showTableOfContents;
        repositoryAdapter = adapter;
        ImageServices.setDestinationFolder((String)outputFolder.getAbsolutePath());
        ImageServices.setRelativeURLBase((String)repositoryAdapter.getRepository().getRepositoryLocation());
        ImageServices.setImageFolderRelativePath((String)"images");
    }

    public static void dispose() {
        CopyImageUtils.dispose();
        if (adapterFactory != null) {
            adapterFactory.dispose();
        }
        adapterFactory = null;
        outputFolder = null;
        repositoryAdapter = null;
        traceabilityIndex = null;
        repositoryAdapter = null;
    }

    private static ComposedAdapterFactory getAdapterFactory() {
        if (adapterFactory == null) {
            adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        }
        return adapterFactory;
    }
}

