/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks.OpenIntentDocumentationHyperLink;
import org.eclipse.mylyn.docs.intent.client.ui.editor.hyperlinks.OpenWorkingCopyResourceHyperLink;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentHyperLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (!textEditor.isDirty() && region != null && textEditor instanceof IntentEditor && textEditor.getEditorInput() != null) {
            IntentEditorDocument document = (IntentEditorDocument)((IntentDocumentProvider)textEditor.getDocumentProvider()).getDocument(textEditor.getEditorInput());
            EObject element = document.getElementAtOffset(region.getOffset());
            element = this.getMostSpecificElement(element);
            ArrayList hyperLinks = Lists.newArrayList();
            if (element != null) {
                Region hyperlinkRegion = this.getHyperlinkRegion(document, element);
                hyperLinks.addAll(this.doDetectHyperlinks((IntentEditor)textEditor, (IRegion)hyperlinkRegion, element, ((IntentDocumentProvider)document.getIntentEditor().getDocumentProvider()).getListenedElementsHandler().getRepositoryAdapter()));
            }
            if (!hyperLinks.isEmpty()) {
                return hyperLinks.toArray(new IHyperlink[hyperLinks.size()]);
            }
        }
        return new IHyperlink[0];
    }

    private EObject getMostSpecificElement(EObject element) {
        EObject mostSpecificElement = element;
        if (element instanceof StructuralFeatureAffectation && ((StructuralFeatureAffectation)element).getValues().size() > 0 && ((StructuralFeatureAffectation)element).getValues().iterator().next() instanceof ReferenceValue) {
            mostSpecificElement = (ReferenceValue)((StructuralFeatureAffectation)element).getValues().iterator().next();
        }
        return mostSpecificElement;
    }

    private Collection<? extends IHyperlink> doDetectHyperlinks(IntentEditor textEditor, IRegion hyperlinkRegion, EObject element, RepositoryAdapter repositoryAdapter) {
        ArrayList hyperLinks = Lists.newArrayList();
        if (OpenIntentDocumentationHyperLink.canApply(element)) {
            hyperLinks.add(new OpenIntentDocumentationHyperLink(textEditor, hyperlinkRegion, element));
        }
        if (OpenWorkingCopyResourceHyperLink.canApply(repositoryAdapter, element)) {
            hyperLinks.add(new OpenWorkingCopyResourceHyperLink(textEditor, hyperlinkRegion, repositoryAdapter, element));
        }
        return hyperLinks;
    }

    private Region getHyperlinkRegion(IntentEditorDocument document, EObject element) {
        ParsedElementPosition actualPosition = document.getIntentPosition(element);
        int offset = actualPosition.getOffset();
        int length = actualPosition.getLength();
        if (element instanceof IntentReferenceInstruction) {
            try {
                String text = document.get(offset, length);
                int refStart = text.indexOf("\"") + 1;
                offset += refStart;
                length = text.indexOf("\"", refStart) - refStart;
            }
            catch (BadLocationException badLocationException) {}
        }
        Region hyperlinkRegion = new Region(Math.max(0, offset), Math.max(0, length));
        return hyperlinkRegion;
    }
}

