/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.gen.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.mylyn.docs.intent.markup.markup.Image;

public final class ImageServices {
    private static String desinationFolderPath;
    private static String imageFolderPath;
    private static String relativeURLBasePath;

    public static void setDestinationFolder(String desinationFolderAbsolutePath) {
        desinationFolderPath = desinationFolderAbsolutePath;
    }

    public static void setImageFolderRelativePath(String imageFolderRelativePath) {
        imageFolderPath = imageFolderRelativePath;
    }

    public static void setRelativeURLBase(String relativeURLBaseAbsolutePath) {
        relativeURLBasePath = relativeURLBaseAbsolutePath;
    }

    public static String copyImage(Image image) {
        if (imageFolderPath != null && desinationFolderPath != null) {
            String imageURL = image.getUrl();
            try {
                InputStream imageInputStream;
                if (imageURL.startsWith("http")) {
                    imageInputStream = new URL(imageURL).openStream();
                } else {
                    if (imageURL.startsWith("./")) {
                        imageURL = String.valueOf(relativeURLBasePath) + imageURL;
                    }
                    imageInputStream = new FileInputStream(imageURL);
                }
                File targetFolder = new File(String.valueOf(desinationFolderPath) + "/" + imageFolderPath);
                targetFolder.mkdirs();
                String fileName = "";
                fileName = imageURL.lastIndexOf(47) != -1 ? imageURL.substring(imageURL.lastIndexOf(47)) : imageURL;
                File targetFile = new File(String.valueOf(targetFolder.getAbsolutePath()) + "/" + fileName);
                ImageServices.copyFile(imageInputStream, targetFile);
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                return "../" + imageFolderPath + fileName;
            }
            catch (IOException iOException) {}
        }
        return image.getUrl();
    }

    public static void copyFile(InputStream sourceStream, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileOutputStream outputStream = new FileOutputStream(destFile);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = sourceStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            sourceStream.close();
            outputStream.close();
        }
        finally {
            if (sourceStream != null) {
                sourceStream.close();
            }
        }
    }
}

