/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.outline;

import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePageItemProviderAdapterFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.query.IntentHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class IntentOutlinePageItemProvider
extends ReflectiveItemProvider {
    private boolean hideDescriptionUnitsContent;
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public IntentOutlinePageItemProvider(IntentOutlinePageItemProviderAdapterFactory intentOutlinePageItemProviderAdapterFactory, boolean hideDescriptionUnitsContent) {
        super((AdapterFactory)intentOutlinePageItemProviderAdapterFactory);
        this.hideDescriptionUnitsContent = hideDescriptionUnitsContent;
    }

    public Image getImage(Object object) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
        Image returnedImage = null;
        if (labelProvider != null) {
            ImageDescriptor descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(object));
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            returnedImage = ExtendedImageRegistry.getInstance().getImage((Object)descriptor);
        }
        if (returnedImage != null) {
            return this.decorateImageAccordingToStatus(returnedImage, object);
        }
        return null;
    }

    public String getText(Object object) {
        if (this.hideDescriptionUnitsContent && object instanceof DescriptionUnit) {
            return "Paragraph";
        }
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
        return labelProvider.getText(object);
    }

    private Image decorateImageAccordingToStatus(Image baseImage, Object element) {
        Image decoratedImage = baseImage;
        if (element instanceof IntentGenericElement) {
            Iterator statusIterator = IntentHelper.getAllStatus((IntentGenericElement)((IntentGenericElement)element)).iterator();
            boolean foundError = false;
            boolean foundWarning = false;
            boolean foundSyncWarning = false;
            while (!foundError & statusIterator.hasNext()) {
                CompilationStatus status = (CompilationStatus)statusIterator.next();
                foundError = status.getSeverity().equals((Object)CompilationStatusSeverity.ERROR);
                if (!status.getSeverity().equals((Object)CompilationStatusSeverity.WARNING)) continue;
                boolean bl = foundSyncWarning = foundSyncWarning || status.getType() == CompilationMessageType.SYNCHRONIZER_WARNING;
                if (status.getType() == CompilationMessageType.SYNCHRONIZER_WARNING) continue;
                foundWarning = true;
            }
            String imagePath = null;
            if (foundSyncWarning) {
                imagePath = "IMG_ELCL_SYNCED_DISABLED";
            }
            if (foundWarning) {
                imagePath = "IMG_DEC_FIELD_WARNING";
            }
            if (foundError) {
                imagePath = "IMG_DEC_FIELD_ERROR";
            }
            if (imagePath != null) {
                ImageDescriptor errorDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imagePath);
                decoratedImage = new DecorationOverlayIcon(baseImage, errorDescriptor, 2).createImage();
            }
        }
        return decoratedImage;
    }
}

