/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.operation;

import com.google.common.collect.HashMultimap;
import java.util.Stack;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.markup.markup.Container;
import org.eclipse.mylyn.docs.intent.markup.markup.Section;
import org.eclipse.mylyn.docs.intent.markup.markup.StructureElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentReStructurer {
    private Iterable<Container> roots;

    public DocumentReStructurer(Iterable<Container> roots) {
        this.roots = roots;
    }

    public void restructure() {
        for (Container root : this.roots) {
            this.restructure(root);
        }
    }

    private void restructure(Container root) {
        Stack<Container> stack = new Stack<Container>();
        stack.push(root);
        TreeIterator it = root.eAllContents();
        HashMultimap roots2Childs = HashMultimap.create();
        while (it.hasNext()) {
            EObject cur = (EObject)it.next();
            if (cur instanceof StructureElement && cur.eContainer() != stack.peek()) {
                roots2Childs.put((Object)((Container)stack.peek()), (Object)((StructureElement)cur));
            }
            if (!(cur instanceof Section)) continue;
            if (stack.peek() instanceof Section) {
                if (((Section)cur).getLevel() >= ((Section)stack.peek()).getLevel()) continue;
                stack.pop();
                continue;
            }
            stack.push((Container)cur);
        }
        for (Container container : roots2Childs.keys()) {
            for (StructureElement child : roots2Childs.get((Object)container)) {
                container.getContent().add((Object)child);
            }
        }
    }
}

