/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.uri;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.internal.uri.contribution.IntentResourceInitializerRegistry;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.common.uri.IIntentResourceInitializer;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

public class IntentResourceFactory
implements Resource.Factory {
    private static final String INTENT_FACTORY_SCHEME = "intent";
    private static final String CREATE_RESOURCE_IF_NEEDED_TAG = "[create]";
    private static final String SLASH = "/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource createResource(URI uri) {
        boolean createResourceIFNeeded = uri.toString().endsWith(IntentResourceFactory.getCreateResourceIfNeededTag());
        URI intentURI = URI.createURI((String)uri.toString().replace(IntentResourceFactory.getCreateResourceIfNeededTag(), ""));
        String intentRepositoryIdentifier = this.extractRepositoryIdentifier(intentURI);
        try {
            Repository repository = IntentRepositoryManager.INSTANCE.getRepository(intentRepositoryIdentifier);
            String compiledResourceIdentifier = this.extractCompiledResourceIdentifier(intentURI);
            String referencedResourcePath = null;
            referencedResourcePath = compiledResourceIdentifier != null && compiledResourceIdentifier.length() > 0 ? "/COMPILATION/GENERATED/" + compiledResourceIdentifier : "/INTENT/IntentDocument";
            RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
            Resource resource = null;
            if (!createResourceIFNeeded) return repositoryAdapter.getResource(referencedResourcePath);
            repositoryAdapter.openSaveContext();
            try {
                resource = repositoryAdapter.getOrCreateResource(referencedResourcePath);
                if (!resource.getContents().isEmpty()) return resource;
                this.fillResource(intentURI, resource, repositoryAdapter);
                return resource;
            }
            finally {
                repositoryAdapter.closeContext();
            }
        }
        catch (RepositoryConnectionException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (ReadOnlyException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillResource(URI intentURI, final Resource resource, RepositoryAdapter repositoryAdapter) throws ReadOnlyException, IOException {
        EObject initialResourceContent = null;
        String fileExtension = intentURI.fileExtension();
        for (IIntentResourceInitializer intentResourceInitializer : IntentResourceInitializerRegistry.getIntentResourceInitializers(fileExtension)) {
            if (initialResourceContent == null) {
                initialResourceContent = intentResourceInitializer.getInitialContent(intentURI);
                continue;
            }
            IntentLogger.getInstance().log(IIntentLogger.LogType.WARNING, "More than one IntentResourceInitializers have been found for the '" + fileExtension + "' file extension. Only the first one will be considered");
        }
        if (initialResourceContent != null) {
            final EObject root = initialResourceContent;
            repositoryAdapter.execute(new IntentCommand(){

                public void execute() {
                    resource.getContents().add((Object)root);
                }
            });
            resource.save(null);
        } else {
            IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Could not find any IIntentResourceInitializer for the '" + fileExtension + "' file extension. You can register new ones using the org.eclipse.mylyn.docs.intent.collab.common.intentresourceinitializer extension point");
        }
    }

    private String extractRepositoryIdentifier(URI uri) {
        String[] paths = uri.path().split(SLASH);
        if (paths.length > 0) {
            return paths[1];
        }
        return "";
    }

    private String extractCompiledResourceIdentifier(URI uri) {
        String uriWithoutFragment = uri.trimFragment().toString();
        String[] paths = uriWithoutFragment.split(SLASH);
        if (paths.length > 2) {
            String compiledResourceIdentifier = paths[2];
            int i = 3;
            while (i < paths.length) {
                compiledResourceIdentifier = String.valueOf(compiledResourceIdentifier) + paths[i];
                ++i;
            }
            if (uri.hasFragment()) {
                compiledResourceIdentifier = String.valueOf(compiledResourceIdentifier) + "_" + uri.fragment().replace(SLASH, "@");
            }
            return compiledResourceIdentifier;
        }
        return "";
    }

    public static String getIntentFactoryScheme() {
        return INTENT_FACTORY_SCHEME;
    }

    public static String getCreateResourceIfNeededTag() {
        return CREATE_RESOURCE_IF_NEEDED_TAG;
    }
}

