/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;

public class IntentPositionManager {
    private Map<EObject, ParsedElementPosition> instructionToPosition = new HashMap<EObject, ParsedElementPosition>();
    private SortedMap<ParsedElementPosition, EObject> positionToInstruction = new TreeMap<ParsedElementPosition, EObject>();

    public void clear() {
        this.instructionToPosition.clear();
        this.positionToInstruction.clear();
    }

    public ParsedElementPosition getPositionForElement(EObject instruction) {
        return this.instructionToPosition.get(instruction);
    }

    public EObject getElementAtPosition(int offset) {
        EObject found = null;
        ParsedElementPosition smallerPosition = null;
        for (Map.Entry<ParsedElementPosition, EObject> entry : this.positionToInstruction.entrySet()) {
            ParsedElementPosition position = entry.getKey();
            if (offset <= position.getOffset() || offset >= position.getOffset() + position.getLength()) continue;
            if (smallerPosition == null) {
                found = entry.getValue();
                smallerPosition = position;
                continue;
            }
            if (smallerPosition.getLength() <= position.getLength()) continue;
            found = entry.getValue();
            smallerPosition = position;
        }
        return found;
    }

    public void addIntentPositionManagerInformations(IntentPositionManager positionManager) {
        this.instructionToPosition.putAll(positionManager.instructionToPosition);
        this.positionToInstruction.putAll(positionManager.positionToInstruction);
    }

    public void setPositionForInstruction(EObject instruction, int offset, int length) {
        ParsedElementPosition parsedElementPosition = new ParsedElementPosition(offset, length);
        this.instructionToPosition.put(instruction, parsedElementPosition);
        this.positionToInstruction.put(parsedElementPosition, instruction);
    }

    public void setPositionForInstruction(EObject instruction, int offset, int length, int declarationLength) {
        ParsedElementPosition parsedElementPosition = new ParsedElementPosition(offset, length, declarationLength);
        this.instructionToPosition.put(instruction, parsedElementPosition);
        this.positionToInstruction.put(parsedElementPosition, instruction);
    }

    public void handleTabulations(int tabOffset, int nbTabs) {
        this.positionToInstruction.clear();
        for (Map.Entry<EObject, ParsedElementPosition> entry : this.instructionToPosition.entrySet()) {
            ParsedElementPosition position = entry.getValue();
            int offset = position.getOffset();
            int length = position.getLength();
            if (offset <= tabOffset && offset + length >= tabOffset) {
                length += nbTabs;
            }
            if (offset >= tabOffset) {
                offset += nbTabs;
            }
            position.setOffset(offset);
            position.setLength(length);
            this.positionToInstruction.put(position, entry.getKey());
        }
    }
}

