/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.internal.contribution;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtensionRegistry;
import org.eclipse.mylyn.docs.intent.client.synchronizer.internal.contribution.ISynchronizerExtensionDescriptor;

public class ISynchronizerExtensionRegistryListener
implements IRegistryChangeListener {
    public static final String SYNCHRONIZER_EXTENSION_POINT = "org.eclipse.mylyn.docs.intent.client.synchronizer.extension";
    private static final String SYNCHRONIZER_EXTENSION_TAG = "SynchronizerExtensionDescription";

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (SYNCHRONIZER_EXTENSION_TAG.equals(elem.getName())) {
                try {
                    ISynchronizerExtensionRegistry.addExtension(new ISynchronizerExtensionDescriptor(elem));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
        IExtensionPoint[] iExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint extensionPoint = iExtensionPointArray[n2];
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n3 = iExtensionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IExtension extension = iExtensionArray[n4];
                this.parseExtension(extension);
                ++n4;
            }
            ++n2;
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        LinkedHashSet addedExtensions = Sets.newLinkedHashSet();
        IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas();
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta extensionDelta = iExtensionDeltaArray[n2];
            addedExtensions.add(extensionDelta.getExtension());
            ++n2;
        }
        this.added(addedExtensions.toArray(new IExtension[addedExtensions.size()]));
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(SYNCHRONIZER_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (SYNCHRONIZER_EXTENSION_TAG.equals(elem.getName())) {
                    String extensionClassName = elem.getAttribute("class");
                    ISynchronizerExtensionRegistry.removeExtension(extensionClassName);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

