/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.compare.match;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.compare.match.EditionDistance;
import org.eclipse.mylyn.docs.intent.compare.utils.LocationDistanceUtils;
import org.eclipse.mylyn.docs.intent.compare.utils.StringDistanceUtils;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.markup.markup.BlockContent;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupPackage;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;
import org.eclipse.mylyn.docs.intent.markup.serializer.WikiTextSerializer;
import org.eclipse.mylyn.docs.intent.serializer.IntentSerializer;

public class IntentCountingDiffEngine
extends EditionDistance.CountingDiffEngine {
    private static final double LOCALIZATION_DISTANCE_WEIGHT = 0.15;
    private static final double IDENTIFIER_DISTANCE_WEIGHT = 0.85;

    public IntentCountingDiffEngine(EditionDistance editionDistance, int maxDistance) {
        EditionDistance editionDistance2 = editionDistance;
        editionDistance2.getClass();
        super(editionDistance2, maxDistance);
    }

    public int measureDifferences(EObject a, EObject b) {
        if (a instanceof IntentDocument && b instanceof IntentDocument) {
            return 0;
        }
        Integer distance = null;
        Integer locationDistance = this.getLocationDistance(a, b);
        Integer identifierDistance = this.getIdentifierDistance(a, b);
        if (identifierDistance == null) {
            identifierDistance = this.getSerializationDistance(a, b);
        }
        distance = identifierDistance != null && locationDistance != null ? Integer.valueOf((int)((double)identifierDistance.intValue() * 0.85 + (double)locationDistance.intValue() * 0.15)) : (identifierDistance != null ? identifierDistance : (locationDistance != null ? locationDistance : Integer.valueOf(super.measureDifferences(a, b))));
        return distance;
    }

    private Integer getLocationDistance(EObject a, EObject b) {
        Integer distance = null;
        String fragmentA = LocationDistanceUtils.computeLevel(a);
        String fragmentB = LocationDistanceUtils.computeLevel(b);
        if (fragmentA != null && fragmentB != null) {
            distance = StringDistanceUtils.getStringDistance(fragmentA, fragmentB);
        }
        return distance;
    }

    private Integer getIdentifierDistance(EObject a, EObject b) {
        Integer distance = null;
        String identifierA = null;
        String identifierB = null;
        if (a instanceof IntentStructuredElement && b instanceof IntentStructuredElement) {
            identifierA = IntentCountingDiffEngine.getTitle((IntentStructuredElement)a);
            identifierB = IntentCountingDiffEngine.getTitle((IntentStructuredElement)b);
        } else if (a instanceof StructuralFeatureAffectation && b instanceof StructuralFeatureAffectation) {
            identifierA = ((StructuralFeatureAffectation)a).getName();
            identifierB = ((StructuralFeatureAffectation)b).getName();
        } else if (a instanceof InstanciationInstruction && b instanceof InstanciationInstruction) {
            identifierA = ((InstanciationInstruction)a).getName();
            identifierB = ((InstanciationInstruction)b).getName();
        } else if (a instanceof ContributionInstruction && b instanceof ContributionInstruction) {
            identifierA = ((ContributionInstruction)a).getContributionReference().getIntentHref();
            identifierB = ((ContributionInstruction)b).getContributionReference().getIntentHref();
        }
        if (identifierA != null && identifierB != null) {
            distance = StringDistanceUtils.getStringDistance(identifierA, identifierB);
        }
        return distance;
    }

    private Integer getSerializationDistance(EObject a, EObject b) {
        Integer distance = null;
        String serializedA = IntentCountingDiffEngine.serialize(a);
        String serializedB = IntentCountingDiffEngine.serialize(b);
        if (serializedA != null && serializedB != null) {
            distance = StringDistanceUtils.getStringDistance(serializedA, serializedB);
        }
        return distance;
    }

    private static String serialize(EObject root) {
        String res = null;
        if (root.eClass().getEPackage().equals(MarkupPackage.eINSTANCE)) {
            res = new WikiTextSerializer().serialize(root);
        } else if (root instanceof ModelingUnit || root instanceof DescriptionUnit || root instanceof IntentStructuredElement) {
            res = new IntentSerializer().serialize(root);
        } else if (root instanceof DescriptionBloc) {
            DescriptionBloc bloc = (DescriptionBloc)root;
            res = IntentCountingDiffEngine.serialize((EObject)bloc.getDescriptionBloc());
        }
        return res;
    }

    private static String getTitle(IntentStructuredElement element) {
        BlockContent content;
        String title = null;
        if (element.getTitle() != null && !element.getTitle().getContent().isEmpty() && (content = (BlockContent)element.getTitle().getContent().get(0)) instanceof Text) {
            title = ((Text)content).getData();
        }
        return title;
    }
}

