/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidReferenceException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.PackageNotFoundResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.PackageRegistrationException;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.ResolveException;
import org.eclipse.mylyn.docs.intent.client.compiler.utils.IntentCompilerInformationHolder;
import org.eclipse.mylyn.docs.intent.core.genericunit.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitLinkResolver {
    private EPackage.Registry packageRegistry;
    private EPackage.Registry invalidPackageRegistry;
    private IntentCompilerInformationHolder informationHolder;

    public ModelingUnitLinkResolver(EPackage.Registry packageRegistry, IntentCompilerInformationHolder informationHolder) {
        this.packageRegistry = packageRegistry;
        this.informationHolder = informationHolder;
        this.invalidPackageRegistry = new EPackageRegistryImpl();
    }

    public EStructuralFeature resolveEStructuralFeature(StructuralFeatureAffectation affectation, EClass eClass) throws ResolveException {
        String featureHRef = affectation.getName();
        try {
            EStructuralFeature foundFeature = eClass.getEStructuralFeature(featureHRef);
            if (foundFeature != null) {
                return foundFeature;
            }
        }
        catch (NullPointerException nullPointerException) {}
        throw new ResolveException((UnitInstruction)affectation, "The feature " + featureHRef + " doesn't exists in " + eClass.getName());
    }

    public EClassifier resolveEClassifierUsingPackageRegistry(UnitInstruction instruction, String href) throws ResolveException {
        ArrayList<EPackage> packageToInspect = new ArrayList<EPackage>();
        for (String packageURI : this.packageRegistry.keySet()) {
            packageToInspect.add(this.packageRegistry.getEPackage(packageURI));
        }
        EClassifier resolvedClassifier = null;
        for (EPackage ePackage : packageToInspect) {
            try {
                resolvedClassifier = ModelingUnitLinkResolver.resolveEClassifierUsingPackage(this.packageRegistry, instruction, ePackage.getNsURI(), href);
            }
            catch (PackageNotFoundResolveException packageNotFoundResolveException) {}
            if (resolvedClassifier != null) break;
        }
        if (resolvedClassifier == null) {
            this.createResolveException(instruction, href);
        }
        return resolvedClassifier;
    }

    public EClassifier resolveEClassifierUsingPackage(UnitInstruction instruction, List<String> packageURIs, String href) throws ResolveException, PackageNotFoundResolveException {
        EClassifier resolvedClass = null;
        for (String nsURI : packageURIs) {
            resolvedClass = ModelingUnitLinkResolver.resolveEClassifierUsingPackage(this.packageRegistry, instruction, nsURI, href);
            if (resolvedClass != null) break;
        }
        if (resolvedClass == null) {
            this.createResolveException(instruction, href);
        }
        return resolvedClass;
    }

    private void createResolveException(UnitInstruction instruction, String href) {
        String message = "The Entity " + href + " cannot be resolved";
        ArrayList<EPackage> packageToInspect = new ArrayList<EPackage>();
        for (String packageURI : this.invalidPackageRegistry.keySet()) {
            packageToInspect.add(this.invalidPackageRegistry.getEPackage(packageURI));
        }
        EClassifier resolvedClassifier = null;
        for (EPackage ePackage : packageToInspect) {
            try {
                resolvedClassifier = ModelingUnitLinkResolver.resolveEClassifierUsingPackage(this.invalidPackageRegistry, instruction, ePackage.getNsURI(), href);
            }
            catch (PackageNotFoundResolveException packageNotFoundResolveException) {}
            if (resolvedClassifier != null) break;
        }
        if (resolvedClassifier != null) {
            message = "The Entity " + href + " exists in the " + resolvedClassifier.getEPackage().getName() + " EPackage but its definition is invalid";
        }
        throw new ResolveException(instruction, message);
    }

    private static EClassifier resolveEClassifierUsingPackage(EPackage.Registry packageRegistry, UnitInstruction instruction, String nsURI, String href) throws PackageNotFoundResolveException {
        EPackage ePackage = packageRegistry.getEPackage(nsURI);
        if (ePackage == null) {
            throw new PackageNotFoundResolveException(instruction, "The package with nsURI \"" + nsURI + "\" cannot be found. ");
        }
        String classifierName = href;
        if (href.contains(".")) {
            classifierName = href.substring(href.lastIndexOf(46) + 1);
            String packageQualifiedName = href.substring(0, href.lastIndexOf(46));
            if (!ModelingUnitLinkResolver.getQualifiedName(ePackage).equals(packageQualifiedName)) {
                return null;
            }
        }
        EClassifier resolvedClass = null;
        EClassifier foundClassifier = ePackage.getEClassifier(classifierName);
        if (foundClassifier != null) {
            resolvedClass = foundClassifier;
            if (instruction instanceof ReferenceValueForStructuralFeature) {
                ((ReferenceValueForStructuralFeature)instruction).setReferencedMetaType((EObject)resolvedClass);
            }
        }
        return resolvedClass;
    }

    private static String getQualifiedName(EPackage ePackage) {
        String res = ePackage.getName();
        EPackage tmp = (EPackage)ePackage.eContainer();
        while (tmp != null) {
            res = String.valueOf(tmp.getName()) + '.' + res;
            tmp = (EPackage)tmp.eContainer();
        }
        return res;
    }

    public EObject resolveReferenceInElementList(UnitInstruction instruction, EClassifier searchedType, String referencedValue) throws InvalidReferenceException {
        EObject foundReference = (EObject)this.informationHolder.getCreatedInstanceByName(searchedType, referencedValue);
        if (foundReference == null) {
            throw new InvalidReferenceException(instruction, "The reference " + referencedValue + " cannot be resolved. ");
        }
        UnitInstruction instanciationInstruction = this.informationHolder.getInstanciationInstructionByCreatedElement(foundReference);
        if (instanciationInstruction instanceof ModelingUnitInstruction && instruction instanceof ContributionInstruction) {
            ((ContributionInstruction)instruction).getContributionReference().setReferencedInstruction((ModelingUnitInstruction)instanciationInstruction);
        } else if (instanciationInstruction instanceof InstanciationInstruction) {
            if (instruction instanceof ReferenceValueForStructuralFeature) {
                ((ReferenceValueForStructuralFeature)instruction).getInstanciationReference().setInstanciation((InstanciationInstruction)instanciationInstruction);
                ((ReferenceValueForStructuralFeature)instruction).setReferencedMetaType((EObject)((InstanciationInstruction)instanciationInstruction).getMetaType().getResolvedType());
            } else if (instruction instanceof ResourceDeclaration) {
                ResourceDeclaration resourceDeclaration = (ResourceDeclaration)instruction;
                for (ModelingUnitInstructionReference reference : resourceDeclaration.getContent()) {
                    if (!referencedValue.equals(reference.getIntentHref())) continue;
                    reference.setReferencedInstruction((ModelingUnitInstruction)instanciationInstruction);
                }
            }
        }
        return foundReference;
    }

    public void registerInPackageRegistry(UnitInstruction instruction, EPackage generatedPackage) {
        if (this.packageRegistry == null) {
            throw new PackageRegistrationException(instruction, "the generated package \"" + generatedPackage.getNsURI() + "\" cannot be registered (maybe because of an invalid connection to the repository)");
        }
        this.packageRegistry.put((Object)generatedPackage.getNsURI(), (Object)generatedPackage);
    }

    public void registerAsInvalidPackage(UnitInstruction instruction, EPackage generatedPackage) {
        this.invalidPackageRegistry.put((Object)generatedPackage.getNsURI(), (Object)generatedPackage);
    }

    public void unregisterEPackage(EPackage ePackage) {
        this.packageRegistry.remove((Object)ePackage.getNsURI());
        this.invalidPackageRegistry.remove((Object)ePackage.getNsURI());
        this.informationHolder.getCurrentImportedPackages().remove(ePackage.getNsURI());
    }
}

