/*******************************************************************************
 * Copyright (c) 2010, 2011 Obeo.

 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.swt.graphics.Image;

/**
 * {@link CompareConfiguration} specifying how compare editors should be displayed.
 * 
 * @author <a href="mailto:alex.lagarde@obeo.fr">Alex Lagarde</a>
 */
public class IntentCompareConfiguration extends CompareConfiguration {

	private EObject workingCopyElement;

	/**
	 * Default constructor.
	 * 
	 * @param generatedResource
	 *            the workingCopyElement element (used by user in working copy)
	 * @param workingCopyResource
	 *            the documentElement element (generated by Intent)
	 */
	public IntentCompareConfiguration(EObject workingCopyElement, EObject documentElement) {
		this.workingCopyElement = workingCopyElement;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.compare.CompareConfiguration#getLeftLabel(java.lang.Object)
	 */
	@Override
	public String getLeftLabel(Object element) {
		return "Working Copy (" + EcoreUtil.getURI(workingCopyElement) + ")";
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.compare.CompareConfiguration#getLeftImage(java.lang.Object)
	 */
	@Override
	public Image getLeftImage(Object element) {
		Object elementToDisplay = element;
		IItemLabelProvider labeProvider = (IItemLabelProvider)new ComposedAdapterFactory(
				ComposedAdapterFactory.Descriptor.Registry.INSTANCE).adapt(element, IItemLabelProvider.class);
		if (labeProvider != null) {
			Object iconURL = labeProvider.getImage(elementToDisplay);
			return ExtendedImageRegistry.getInstance().getImage(iconURL);
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.compare.CompareConfiguration#getRightLabel(java.lang.Object)
	 */
	@Override
	public String getRightLabel(Object element) {
		return "Intent Document";
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.compare.CompareConfiguration#getRightImage(java.lang.Object)
	 */
	@Override
	public Image getRightImage(Object element) {
		return IntentEditorActivator.getDefault().getImage("icon/outline/document.gif");
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.compare.CompareConfiguration#isLeftEditable()
	 */
	@Override
	public boolean isLeftEditable() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.compare.CompareConfiguration#isRightEditable()
	 */
	@Override
	public boolean isRightEditable() {
		return false;
	}
}
