/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtension;
import org.eclipse.mylyn.docs.intent.client.synchronizer.internal.contribution.ISynchronizerExtensionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ISynchronizerExtensionRegistry {
    private static final Map<ISynchronizerExtension, Collection<ISynchronizerExtensionDescriptor>> EXTENSIONS = Maps.newHashMap();

    private ISynchronizerExtensionRegistry() {
    }

    public static void addExtension(ISynchronizerExtensionDescriptor extension) {
        ISynchronizerExtension synchronizerExtension = extension.getSynchronizerExtension();
        if (EXTENSIONS.get(synchronizerExtension) == null) {
            EXTENSIONS.put(synchronizerExtension, new HashSet());
        }
        EXTENSIONS.get(synchronizerExtension).add(extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<ISynchronizerExtensionDescriptor> getRegisteredExtensions() {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<ISynchronizerExtensionDescriptor> extensions : EXTENSIONS.values()) {
            registeredExtensions.addAll(extensions);
        }
        return registeredExtensions;
    }

    public static Collection<ISynchronizerExtension> getSynchronizerExtensions(URI uri) {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<ISynchronizerExtensionDescriptor> extensions : EXTENSIONS.values()) {
            for (ISynchronizerExtensionDescriptor descriptor : extensions) {
                if (!descriptor.getSynchronizerExtension().isExtensionFor(uri)) continue;
                registeredExtensions.add(descriptor.getSynchronizerExtension());
            }
        }
        return registeredExtensions;
    }

    public static void removeExtension(String extensionClassName) {
        for (ISynchronizerExtensionDescriptor extension : ISynchronizerExtensionRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.get(extension.getSynchronizerExtension()).clear();
        }
    }
}

