/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.modelingunit.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AbstractValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AffectationOperator;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitFactory;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.core.modelingunit.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelingUnitGenerator {
    protected RepositoryAdapter repositoryAdapter;
    protected ResourceSet resourceSet = new ResourceSetImpl();
    private List<EObject> newObjects;

    public AbstractModelingUnitGenerator(RepositoryAdapter repositoryAdapter) {
        this.repositoryAdapter = repositoryAdapter;
    }

    public void setNewObjects(List<EObject> newObjects) {
        this.newObjects = newObjects;
    }

    public ContributionInstruction generateContribution(InstanciationInstruction instanciation) {
        ContributionInstruction contribution = ModelingUnitFactory.eINSTANCE.createContributionInstruction();
        contribution.setLineBreak(true);
        ModelingUnitInstructionReference ref = ModelingUnitFactory.eINSTANCE.createModelingUnitInstructionReference();
        ref.setReferencedInstruction((ModelingUnitInstruction)instanciation);
        if (instanciation.getName() == null) {
            EObject generated = this.getGeneratedElement(instanciation);
            instanciation.setName(this.getReferenceName(generated));
        }
        ref.setIntentHref(instanciation.getName());
        contribution.setContributionReference(ref);
        return contribution;
    }

    public InstanciationInstruction generateInstanciation(EObject root) {
        InstanciationInstruction instanciation = ModelingUnitFactory.eINSTANCE.createInstanciationInstruction();
        instanciation.setName(this.getReferenceName(root));
        TypeReference typeReference = ModelingUnitFactory.eINSTANCE.createTypeReference();
        typeReference.setTypeName(root.eClass().getName());
        typeReference.setResolvedType(root.eClass());
        instanciation.setMetaType(typeReference);
        for (EStructuralFeature feature : root.eClass().getEAllStructuralFeatures()) {
            if (this.filter(feature)) continue;
            instanciation.getStructuralFeatures().addAll(this.generateAffectations(feature, root.eGet(feature)));
        }
        return instanciation;
    }

    public List<StructuralFeatureAffectation> generateAffectations(EStructuralFeature feature, Object workingCopyValue) {
        ArrayList<StructuralFeatureAffectation> affectations = new ArrayList<StructuralFeatureAffectation>();
        if (workingCopyValue instanceof Collection) {
            for (Object singleValue : (Collection)workingCopyValue) {
                StructuralFeatureAffectation affectation = this.generateSingleAffectation(feature, singleValue);
                if (affectation == null) continue;
                affectations.add(affectation);
            }
        } else {
            StructuralFeatureAffectation affectation = this.generateSingleAffectation(feature, workingCopyValue);
            if (affectation != null) {
                affectations.add(affectation);
            }
        }
        return affectations;
    }

    public StructuralFeatureAffectation generateSingleAffectation(EStructuralFeature feature, Object workingCopyValue) {
        StructuralFeatureAffectation affectation = null;
        if (!(workingCopyValue == null || feature.getDefaultValue() != null && workingCopyValue.equals(feature.getDefaultValue()))) {
            affectation = ModelingUnitFactory.eINSTANCE.createStructuralFeatureAffectation();
            affectation.setLineBreak(true);
            affectation.setName(feature.getName());
            if (feature.isMany()) {
                affectation.setUsedOperator(AffectationOperator.MULTI_VALUED_AFFECTATION);
            } else {
                affectation.setUsedOperator(AffectationOperator.SINGLE_VALUED_AFFECTATION);
            }
            AbstractValue generateValue = this.generateValue(feature, workingCopyValue);
            if (generateValue != null) {
                affectation.getValues().add((Object)generateValue);
            } else {
                affectation = null;
            }
        }
        return affectation;
    }

    public boolean setValue(AbstractValue valueInstruction, Object newValue) {
        boolean res = true;
        switch (valueInstruction.eClass().getClassifierID()) {
            case 8: {
                ((NativeValue)valueInstruction).setValue("\"" + newValue.toString() + "\"");
                break;
            }
            case 9: {
                ((NewObjectValue)valueInstruction).setValue(this.generateInstanciation((EObject)newValue));
                break;
            }
            case 10: {
                if (newValue instanceof EDataType) {
                    InstanciationInstructionReference instanciationRef = ModelingUnitFactory.eINSTANCE.createInstanciationInstructionReference();
                    instanciationRef.setInstanceName(((EDataType)newValue).getName());
                    ((ReferenceValue)valueInstruction).setReferenceType((EObject)((EDataType)newValue));
                    ((ReferenceValue)valueInstruction).setInstanciationReference(instanciationRef);
                    break;
                }
                InstanciationInstructionReference reference = ModelingUnitFactory.eINSTANCE.createInstanciationInstructionReference();
                InstanciationInstruction instanciation = this.getExistingInstanciationFor((EObject)newValue);
                if (instanciation != null) {
                    if (instanciation.getName() == null) {
                        instanciation.setName(this.getReferenceName(this.getGeneratedElement(instanciation)));
                    }
                    reference.setInstanceName(instanciation.getName());
                    ((ReferenceValue)valueInstruction).setInstanciationReference(reference);
                    break;
                }
                if (this.newObjects != null && this.newObjects.contains(newValue)) {
                    reference.setInstanceName(this.getReferenceName((EObject)newValue));
                    ((ReferenceValue)valueInstruction).setInstanciationReference(reference);
                    break;
                }
                res = false;
                break;
            }
        }
        return res;
    }

    private AbstractValue generateValue(EStructuralFeature feature, Object value) {
        Object res = null;
        if (feature instanceof EAttribute) {
            res = ModelingUnitFactory.eINSTANCE.createNativeValue();
        } else if (feature instanceof EReference) {
            res = ((EReference)feature).isContainment() ? ModelingUnitFactory.eINSTANCE.createNewObjectValue() : ModelingUnitFactory.eINSTANCE.createReferenceValue();
        }
        if (this.setValue((AbstractValue)res, value)) {
            return res;
        }
        return null;
    }

    protected boolean filter(EStructuralFeature feature) {
        boolean isUnsettable;
        boolean bl = isUnsettable = feature instanceof EReference && ((EReference)feature).isContainment() && feature.isUnsettable();
        return !feature.isChangeable() || feature.isDerived() || isUnsettable || feature.isTransient();
    }

    protected abstract EObject getGeneratedElement(InstanciationInstruction var1);

    protected abstract InstanciationInstruction getExistingInstanciationFor(EObject var1);

    protected abstract String getReferenceName(EObject var1);
}

