/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.state;

import org.eclipse.mylyn.docs.intent.markup.builder.BuilderState;
import org.eclipse.mylyn.docs.intent.markup.builder.operation.HasAttributeCopyAttributes;
import org.eclipse.mylyn.docs.intent.markup.builder.state.SBlock;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.markup.markup.Link;
import org.eclipse.mylyn.docs.intent.markup.markup.MarkupFactory;
import org.eclipse.mylyn.docs.intent.markup.markup.Text;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;

public class SLink
extends SBlock {
    private static final String LEFT_PAR = "(";
    private static final String RIGHT_PAR = ")";
    private Link currentLink;

    public SLink(BuilderState previous, Block linkName, Link link) {
        super(previous, linkName);
        this.currentLink = link;
    }

    public BuilderState characters(String text) {
        String linkText = text;
        if (text.contains(LEFT_PAR) && text.contains(RIGHT_PAR)) {
            Attributes linkAttributes = new Attributes();
            int indiceLastPar = text.lastIndexOf(LEFT_PAR);
            linkText = text.substring(0, indiceLastPar);
            String linkTitle = text.replace(linkText, "").replace(LEFT_PAR, "").replace(RIGHT_PAR, "");
            linkAttributes.setTitle(linkTitle);
            new HasAttributeCopyAttributes(this.currentLink).setValues(linkAttributes);
        }
        Text newText = MarkupFactory.eINSTANCE.createText();
        newText.setData(linkText);
        this.addAllFormatsFromStack(newText);
        this.currentText = newText;
        this.block.getContent().add((Object)newText);
        return this;
    }

    public BuilderState charactersUnescaped(String literal) {
        return this.previousState().charactersUnescaped(literal);
    }

    public BuilderState endSpan() {
        if (this.spanStack.isEmpty()) {
            return this.previousState();
        }
        return super.endSpan();
    }
}

