/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.query;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.genericunit.GenericUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitGetter {
    private UnitGetter() {
    }

    public static EList<ModelingUnit> getAllModelingUnitsContainedInElement(EObject element) {
        BasicEList containedModelingUnits = new BasicEList();
        if (element instanceof ModelingUnit) {
            containedModelingUnits.add((Object)((ModelingUnit)element));
        }
        if (element instanceof IntentSection) {
            containedModelingUnits.addAll(UnitGetter.getAllModelingUnitsContainedInSection((IntentSection)element));
        }
        if (element instanceof IntentChapter) {
            containedModelingUnits.addAll(UnitGetter.getAllModelingUnitsContainedInChapter((IntentChapter)element));
        }
        if (element instanceof IntentDocument) {
            containedModelingUnits.addAll(UnitGetter.getAllModelingUnitsContainedInIntentDocument((IntentDocument)element));
        }
        return containedModelingUnits;
    }

    private static EList<ModelingUnit> getAllModelingUnitsContainedInIntentDocument(IntentDocument document) {
        BasicEList containedModelingUnits = new BasicEList();
        for (IntentChapter chapter : document.getChapters()) {
            containedModelingUnits.addAll(UnitGetter.getAllModelingUnitsContainedInChapter(chapter));
        }
        return containedModelingUnits;
    }

    private static EList<ModelingUnit> getAllModelingUnitsContainedInChapter(IntentChapter chapter) {
        BasicEList containedModelingUnits = new BasicEList();
        for (IntentSection section : chapter.getSubSections()) {
            containedModelingUnits.addAll(UnitGetter.getAllModelingUnitsContainedInSection(section));
        }
        return containedModelingUnits;
    }

    private static EList<ModelingUnit> getAllModelingUnitsContainedInSection(IntentSection section) {
        BasicEList containedModelingUnits = new BasicEList();
        for (GenericUnit unit : section.getUnits()) {
            if (!(unit instanceof ModelingUnit)) continue;
            containedModelingUnits.add((Object)((ModelingUnit)unit));
        }
        for (IntentSection subSection : section.getSubSections()) {
            containedModelingUnits.addAll(UnitGetter.getAllModelingUnitsContainedInSection(subSection));
        }
        return containedModelingUnits;
    }

    public static EList<DescriptionUnit> getAllDescriptionUnitsContainedInElement(EObject element) {
        BasicEList containedDescriptionUnits = new BasicEList();
        if (element instanceof DescriptionUnit) {
            containedDescriptionUnits.add((Object)((DescriptionUnit)element));
        }
        if (element instanceof IntentSection) {
            containedDescriptionUnits.addAll(UnitGetter.getAllDescriptionUnitsContainedInSection((IntentSection)element));
        }
        if (element instanceof IntentChapter) {
            containedDescriptionUnits.addAll(UnitGetter.getAllDescriptionUnitsContainedInChapter((IntentChapter)element));
        }
        if (element instanceof IntentDocument) {
            containedDescriptionUnits.addAll(UnitGetter.getAllDescriptionUnitsContainedInIntentDocument((IntentDocument)element));
        }
        return containedDescriptionUnits;
    }

    private static EList<DescriptionUnit> getAllDescriptionUnitsContainedInIntentDocument(IntentDocument document) {
        BasicEList containedDescriptionUnits = new BasicEList();
        for (IntentChapter chapter : document.getChapters()) {
            containedDescriptionUnits.addAll(UnitGetter.getAllDescriptionUnitsContainedInChapter(chapter));
        }
        return containedDescriptionUnits;
    }

    private static EList<DescriptionUnit> getAllDescriptionUnitsContainedInChapter(IntentChapter chapter) {
        BasicEList containedDescriptionUnits = new BasicEList();
        containedDescriptionUnits.addAll(chapter.getDescriptionUnits());
        for (IntentSection section : chapter.getSubSections()) {
            containedDescriptionUnits.addAll(UnitGetter.getAllDescriptionUnitsContainedInSection(section));
        }
        return containedDescriptionUnits;
    }

    private static EList<DescriptionUnit> getAllDescriptionUnitsContainedInSection(IntentSection section) {
        BasicEList containedDescriptionUnits = new BasicEList();
        for (GenericUnit unit : section.getUnits()) {
            if (!(unit instanceof DescriptionUnit)) continue;
            containedDescriptionUnits.add((Object)((DescriptionUnit)unit));
        }
        for (IntentSection subSection : section.getSubSections()) {
            containedDescriptionUnits.addAll(UnitGetter.getAllDescriptionUnitsContainedInSection(subSection));
        }
        return containedDescriptionUnits;
    }
}

