/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.synchronizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mylyn.docs.intent.client.synchronizer.SynchronizerRepositoryClient;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtension;
import org.eclipse.mylyn.docs.intent.client.synchronizer.api.contribution.ISynchronizerExtensionRegistry;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchronizerStatusFactory;
import org.eclipse.mylyn.docs.intent.client.synchronizer.listeners.GeneratedElementListener;
import org.eclipse.mylyn.docs.intent.client.synchronizer.strategy.DefaultSynchronizerStrategy;
import org.eclipse.mylyn.docs.intent.client.synchronizer.strategy.SynchronizerStrategy;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.InstructionTraceabilityEntry;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentSynchronizer {
    private SynchronizerStrategy synchronizerStrategy;
    private GeneratedElementListener defaultSynchronizedElementListener;
    private SynchronizerRepositoryClient repositoryClient;

    public IntentSynchronizer(SynchronizerRepositoryClient synchronizerRepositoryClient) {
        this.repositoryClient = synchronizerRepositoryClient;
        this.synchronizerStrategy = new DefaultSynchronizerStrategy();
    }

    public void setSynchronizerStrategy(SynchronizerStrategy strategy) {
        this.synchronizerStrategy = strategy;
    }

    public void setGeneratedElementListener(GeneratedElementListener generatedElementListener) {
        this.defaultSynchronizedElementListener = generatedElementListener;
    }

    public Collection<? extends CompilationStatus> synchronize(RepositoryAdapter adapter, TraceabilityIndex tracabilityIndex, Monitor progressMonitor) throws InterruptedException {
        ArrayList<? extends CompilationStatus> statusList = new ArrayList<CompilationStatus>();
        if (this.defaultSynchronizedElementListener != null) {
            this.defaultSynchronizedElementListener.clearElementToListen();
        }
        Iterator indexEntryIterator = tracabilityIndex.getEntries().iterator();
        while (indexEntryIterator.hasNext()) {
            this.stopIfCanceled(progressMonitor);
            TraceabilityIndexEntry indexEntry = (TraceabilityIndexEntry)indexEntryIterator.next();
            if (indexEntry.getResourceDeclaration() == null) continue;
            this.clearSyncStatusesFromIndexEntry(indexEntry);
            if (indexEntry.getResourceDeclaration().getUri() == null) continue;
            Collection<? extends CompilationStatus> synchronizedStatus = this.synchronize(adapter, indexEntry, progressMonitor);
            statusList.addAll(synchronizedStatus);
        }
        return statusList;
    }

    private void clearSyncStatusesFromIndexEntry(TraceabilityIndexEntry indexEntry) {
        Iterator statusIterator = indexEntry.getResourceDeclaration().getCompilationStatus().iterator();
        while (statusIterator.hasNext()) {
            CompilationStatus status = (CompilationStatus)statusIterator.next();
            if (!this.isSyncStatus(status)) continue;
            statusIterator.remove();
        }
        for (EObject containedElement : indexEntry.getContainedElementToInstructions().keySet()) {
            EList instructionEntries = (EList)indexEntry.getContainedElementToInstructions().get((Object)containedElement);
            if (instructionEntries == null) continue;
            for (InstructionTraceabilityEntry instructionTraceabilityEntry : instructionEntries) {
                EList compilationStatus;
                IntentGenericElement instruction = instructionTraceabilityEntry.getInstruction();
                if (instruction == null || (compilationStatus = instruction.getCompilationStatus()) == null) continue;
                Iterator iterator = compilationStatus.iterator();
                while (iterator.hasNext()) {
                    CompilationStatus status = (CompilationStatus)iterator.next();
                    if (!this.isSyncStatus(status)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private boolean isSyncStatus(CompilationStatus status) {
        CompilationMessageType type = status.getType();
        return type.equals((Object)CompilationMessageType.SYNCHRONIZER_WARNING) || type.equals((Object)CompilationMessageType.SYNCHRONIZER_INFO);
    }

    private Collection<? extends CompilationStatus> synchronize(RepositoryAdapter adapter, final TraceabilityIndexEntry indexEntry, Monitor progressMonitor) throws InterruptedException {
        ArrayList result;
        List<Object> statusList = new ArrayList<Object>();
        boolean continueSynchronization = true;
        this.stopIfCanceled(progressMonitor);
        Resource internalResource = this.getInternalResource(adapter, indexEntry);
        this.stopIfCanceled(progressMonitor);
        Resource externalResource = this.getExternalResource(indexEntry);
        this.stopIfCanceled(progressMonitor);
        if (internalResource == null) {
            result = new ArrayList();
            final Resource finalExternalResource = externalResource;
            adapter.execute(new IntentCommand(){

                public void execute() {
                    result.add(IntentSynchronizer.this.synchronizerStrategy.handleNullInternalResource(indexEntry.getGeneratedResourcePath(), finalExternalResource));
                }
            });
            if (!result.isEmpty()) {
                internalResource = (Resource)result.get(0);
            }
            boolean bl = continueSynchronization = internalResource != null;
        }
        if (externalResource == null) {
            result = new ArrayList();
            final Resource finalInternalResource = internalResource;
            adapter.execute(new IntentCommand(){

                public void execute() {
                    Resource handleNullExternalResource = IntentSynchronizer.this.synchronizerStrategy.handleNullExternalResource(indexEntry.getResourceDeclaration(), finalInternalResource, indexEntry.getResourceDeclaration().getUri());
                    if (handleNullExternalResource != null) {
                        result.add(handleNullExternalResource);
                    }
                }
            });
            if (!result.isEmpty()) {
                externalResource = (Resource)result.get(0);
            } else {
                Collection<? extends CompilationStatus> statusForNullExternalresource = this.synchronizerStrategy.getStatusForNullExternalResource(indexEntry.getResourceDeclaration(), indexEntry.getGeneratedResourcePath());
                statusList.addAll(statusForNullExternalresource);
                this.updateSynchronizedElementsListeners(IntentSynchronizer.getResourceDeclarationURI(indexEntry.getResourceDeclaration()));
            }
            continueSynchronization = externalResource != null;
        }
        this.stopIfCanceled(progressMonitor);
        if (continueSynchronization) {
            if (externalResource.getContents().isEmpty() && !internalResource.getContents().isEmpty()) {
                Collection<? extends CompilationStatus> statusForEmptyExternalresource = this.synchronizerStrategy.getStatusForEmptyExternalResource(indexEntry.getResourceDeclaration(), indexEntry.getGeneratedResourcePath());
                statusList.addAll(statusForEmptyExternalresource);
                this.updateSynchronizedElementsListeners(IntentSynchronizer.getResourceDeclarationURI(indexEntry.getResourceDeclaration()));
            } else if (internalResource.getContents().isEmpty() && !externalResource.getContents().isEmpty()) {
                Collection<? extends CompilationStatus> statusForEmptyInternalResource = this.synchronizerStrategy.getStatusForEmptyInternalResource(indexEntry.getResourceDeclaration(), indexEntry.getGeneratedResourcePath());
                statusList.addAll(statusForEmptyInternalResource);
                this.updateSynchronizedElementsListeners(IntentSynchronizer.getResourceDeclarationURI(indexEntry.getResourceDeclaration()));
            } else {
                Resource leftResource = this.synchronizerStrategy.getLeftResource(internalResource, externalResource);
                Resource rightResource = this.synchronizerStrategy.getRightResource(internalResource, externalResource);
                List<DiffElement> differences = null;
                this.stopIfCanceled(progressMonitor);
                differences = this.compareResource(leftResource, rightResource);
                this.stopIfCanceled(progressMonitor);
                statusList = this.createSynchronizerSatusListFromDiffModel(indexEntry, differences, progressMonitor);
                externalResource.unload();
                this.updateSynchronizedElementsListeners(externalResource.getURI());
            }
        } else {
            this.stopIfCanceled(progressMonitor);
        }
        return statusList;
    }

    private void updateSynchronizedElementsListeners(URI uri) {
        boolean foundSpecificSynchronizer = false;
        if (uri.scheme() != null) {
            for (ISynchronizerExtension synchronizerExtension : ISynchronizerExtensionRegistry.getSynchronizerExtensions(uri.scheme())) {
                if (synchronizerExtension == null) continue;
                synchronizerExtension.addListenedElements(this.repositoryClient, Sets.newHashSet((Object[])new URI[]{uri}));
                foundSpecificSynchronizer = true;
            }
        }
        if (!foundSpecificSynchronizer && this.defaultSynchronizedElementListener != null) {
            this.defaultSynchronizedElementListener.addElementToListen(uri);
        }
    }

    private void stopIfCanceled(Monitor progressMonitor) throws InterruptedException {
        if (progressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private List<CompilationStatus> createSynchronizerSatusListFromDiffModel(TraceabilityIndexEntry indexEntry, List<DiffElement> differences, Monitor progressMonitor) throws InterruptedException {
        LinkedHashMap elementToSyncStatus = Maps.newLinkedHashMap();
        ArrayList<CompilationStatus> statusList = new ArrayList<CompilationStatus>();
        for (DiffElement difference : differences) {
            this.stopIfCanceled(progressMonitor);
            for (CompilationStatus newStatus : SynchronizerStatusFactory.createStatusFromDiffElement(indexEntry, difference)) {
                this.stopIfCanceled(progressMonitor);
                if (elementToSyncStatus.get(newStatus.getTarget()) == null) {
                    elementToSyncStatus.put(newStatus.getTarget(), Lists.newArrayList());
                }
                ((Collection)elementToSyncStatus.get(newStatus.getTarget())).add(newStatus);
                statusList.add(newStatus);
            }
        }
        return statusList;
    }

    private Resource getInternalResource(RepositoryAdapter adapter, TraceabilityIndexEntry indexEntry) {
        try {
            return adapter.getResource(indexEntry.getGeneratedResourcePath());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Resource getExternalResource(TraceabilityIndexEntry indexEntry) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = null;
        if (indexEntry.getResourceDeclaration() != null) {
            URI externalURI = IntentSynchronizer.getResourceDeclarationURI(indexEntry.getResourceDeclaration());
            try {
                resource = resourceSet.getResource(externalURI, true);
            }
            catch (WrappedException wrappedException) {
                resource = null;
            }
        }
        return resource;
    }

    private List<DiffElement> compareResource(Resource leftResource, Resource rightResource) throws InterruptedException {
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("match.ignore.xmi.id", Boolean.TRUE);
            MatchModel matchModel = MatchService.doResourceMatch((Resource)leftResource, (Resource)rightResource, options);
            DiffModel diff = DiffService.doDiff((MatchModel)matchModel, (boolean)false);
            return diff.getDifferences();
        }
        catch (Exception exception) {
            return new ArrayList<DiffElement>();
        }
    }

    public void dispose() {
        this.defaultSynchronizedElementListener.dispose();
    }

    private static URI getResourceDeclarationURI(ResourceDeclaration resourceDeclaration) {
        return URI.createURI((String)resourceDeclaration.getUri().toString().replace("\"", ""));
    }
}

