/*******************************************************************************
 * Copyright (c) 2017, 2018 1C-Soft LLC.
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Vladimir Piskarev (1C) - initial API and implementation
 *******************************************************************************/
package org.eclipse.handly.model;

import org.eclipse.core.resources.IResource;

/**
 * Provides a generic way to create {@link IElement} handles. An instance of
 * <code>IElementHandleFactory</code> for a model can usually be obtained via
 * the model's {@link Models#getModelContext(IModel) context} by <code>
 * context.get(IElementHandleFactory.class)</code>.
 * <p>
 * Note that, despite having a dependency on {@link IResource}, this interface can
 * safely be used even when <code>org.eclipse.core.resources</code> bundle is not
 * available. This is based on the "outward impression" of late resolution of
 * symbolic references a JVM must provide according to the JVMS.
 * </p>
 */
public interface IElementHandleFactory
{
    /**
     * Returns the element handle created from the given handle memento
     * that was generated by {@link Elements#getHandleMemento(IElement)}.
     *
     * @param memento a handle memento (may be <code>null</code>)
     * @return the element handle created from the given memento,
     *  or <code>null</code> if unable to create an element handle
     *  from the given memento
     */
    IElement createFromHandleMemento(String memento);

    /**
     * Returns the handle of the element corresponding to the given resource.
     *
     * @param resource a resource handle (may be <code>null</code>)
     * @return the handle of the element corresponding to the given resource,
     *  or <code>null</code> if unable to associate the given resource with
     *  an element
     */
    IElement createFromResourceHandle(IResource resource);
}
