/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;

public class DoSubdirs
extends Task {
    private String todo;
    private String srcdir;
    private String includes;
    private String excludes;
    private boolean failonerror = false;
    private String[] includesArray;
    private String[] excludesArray;
    private static List failedDirs;

    public void setIncludes(String inc) {
        this.includes = inc;
    }

    public void setExcludes(String exc) {
        this.excludes = exc;
    }

    private void myinit() {
        String item;
        int i;
        if (this.excludes != null && this.excludes.length() != 0) {
            StringTokenizer st1 = new StringTokenizer(this.excludes, ", \t\n\r\f");
            int tokens1 = st1.countTokens();
            this.excludesArray = new String[tokens1];
            for (i = 0; i < tokens1; ++i) {
                item = st1.nextToken();
                if (item.endsWith("build.xml")) {
                    this.excludesArray[i] = item;
                    continue;
                }
                if (!item.endsWith("/") && !item.endsWith("\\")) {
                    item = item + "/";
                }
                this.excludesArray[i] = item;
            }
        }
        if (this.includes == null || this.includes.length() == 0) {
            this.includesArray = new String[1];
            this.includesArray[0] = "**/build.xml";
        } else {
            StringTokenizer st2 = new StringTokenizer(this.includes, ", \t\n\r\f");
            int tokens2 = st2.countTokens();
            this.includesArray = new String[tokens2];
            for (i = 0; i < tokens2; ++i) {
                item = st2.nextToken();
                if (item.endsWith("build.xml")) {
                    this.includesArray[i] = item;
                    continue;
                }
                if (!item.endsWith("/") && !item.endsWith("\\")) {
                    item = item + "/";
                }
                this.includesArray[i] = item = item + "**/build.xml";
            }
        }
    }

    public void execute() throws BuildException {
        File currentDir = null;
        String[] buildfiles = null;
        try {
            this.myinit();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setIncludes(this.includesArray);
            ds.setExcludes(this.excludesArray);
            ds.setBasedir(new File(this.srcdir));
            ds.scan();
            buildfiles = ds.getIncludedFiles();
        }
        catch (Throwable th) {
            th.printStackTrace();
            TSLogger.addFailedDir("While initializing dosubidrs and scanning.");
        }
        for (int i = 0; i < buildfiles.length; ++i) {
            try {
                File leafDir;
                currentDir = leafDir = new File(this.srcdir, (String)buildfiles[i]).getParentFile();
                Ant antTask = new Ant();
                antTask.setProject(this.project);
                antTask.init();
                antTask.setInheritAll(false);
                antTask.setAntfile("build.xml");
                antTask.setDir(leafDir);
                antTask.setTarget(this.todo);
                Property prop = antTask.createProperty();
                prop.setName("called.by.dosubdirs");
                prop.setValue("true");
                String msg = "Entering " + leafDir.getPath();
                this.log(msg);
                antTask.execute();
                antTask = null;
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
                DoSubdirs.addFailedDir(currentDir == null ? "Unknown" : currentDir.getPath());
            }
        }
        this.logFailedDirs();
    }

    public void setTodo(String todo) {
        this.todo = todo;
    }

    public void setSrcdir(String srcdir) {
        this.srcdir = srcdir;
    }

    public void setFailonerror(String foe) {
        this.failonerror = Boolean.parseBoolean(foe);
    }

    private void logFailedDirs() {
        StringBuffer sb = null;
        if (failedDirs != null) {
            sb = new StringBuffer();
            int n = failedDirs.size();
            for (int i = 0; i < n; ++i) {
                sb.append(failedDirs.get(i).toString()).append('\n');
            }
            System.err.println("BUILD FAILED");
            System.err.println("The following directories failed:");
            System.err.println(sb.toString());
        }
        if (failedDirs != null && this.failonerror) {
            throw new BuildException("ERROR: Some directories failed to build.  See list of failed directories above.");
        }
    }

    public static void addFailedDir(String s) {
        if (failedDirs == null) {
            failedDirs = new ArrayList();
        }
        if (!failedDirs.contains(s)) {
            failedDirs.add(s);
        }
    }
}

