/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.input.trace;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.simulator.input.AutomaticInputComponent;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.input.InputComponent;
import org.eclipse.escet.cif.simulator.input.trace.EventTraceCommand;
import org.eclipse.escet.cif.simulator.input.trace.InputVarUpdateTraceCommand;
import org.eclipse.escet.cif.simulator.input.trace.TimeMode;
import org.eclipse.escet.cif.simulator.input.trace.TimeTraceCommand;
import org.eclipse.escet.cif.simulator.input.trace.TraceCommand;
import org.eclipse.escet.cif.simulator.input.trace.TraceInputRuntimeEnvironmentEvent;
import org.eclipse.escet.cif.simulator.options.TraceInputFileOption;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.SimulatorExitException;
import org.eclipse.escet.cif.simulator.runtime.io.RuntimeLiteralReader;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEvent;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEventKind;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class TraceInputComponent<S extends RuntimeState>
extends InputComponent<S> {
    private Boolean strict;
    private TimeMode timeMode;
    private List<TraceCommand> commands;
    private int curCommandIdx = 0;
    private boolean allowDelay;
    private AutomaticInputComponent<S> autoInput;

    public TraceInputComponent(RuntimeSpec<S> spec) {
        super(spec);
    }

    @Override
    public void init() {
        String path = TraceInputFileOption.getPath();
        String absPath = Paths.resolve((String)path);
        try {
            this.readTraceFile(path, absPath);
        }
        catch (InvalidInputException ex) {
            String msg = Strings.fmt((String)"Trace file \"%s\" is invalid.", (Object[])new Object[]{path});
            throw new InvalidInputException(msg, (Throwable)ex);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readTraceFile(String path, String absPath) {
        try {
            stream /* !! */  = new FileInputStream(absPath);
            stream /* !! */  = new BufferedInputStream(stream /* !! */ );
            lines = IOUtils.readLines((InputStream)stream /* !! */ , (String)"UTF-8");
        }
        catch (IOException ex) {
            msg = Strings.fmt((String)"Failed to read trace file \"%s\".", (Object[])new Object[]{path});
            throw new InputOutputException(msg, (Throwable)ex);
        }
        lines2 = Lists.listc((int)lines.size());
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            lines2.add(line);
        }
        lines = lines2;
        i = 0;
        while (i < lines.size()) {
            line = (String)lines.get(i);
            if (!line.startsWith("option")) break;
            ++i;
            parts = StringUtils.split((String)line);
            valid = true;
            if (parts.length != 3) {
                valid = false;
            }
            if (valid && !parts[0].equals("option")) {
                valid = false;
            }
            if (valid) {
                var9_12 = parts[1];
                tmp = -1;
                switch (var9_12.hashCode()) {
                    case -891986231: {
                        if (!var9_12.equals("strict")) break;
                        tmp = 1;
                        break;
                    }
                    case 3560141: {
                        if (!var9_12.equals("time")) break;
                        tmp = 1;
                        break;
                    }
                }
                switch (tmp) {
                    default: {
                        valid = false;
                        break;
                    }
                    case 1: 
                }
            }
            if (valid && parts[1].equals("strict")) {
                var9_12 = parts[2];
                tmp = -1;
                switch (var9_12.hashCode()) {
                    case 3551: {
                        if (!var9_12.equals("on")) break;
                        tmp = 1;
                        break;
                    }
                    case 109935: {
                        if (!var9_12.equals("off")) break;
                        tmp = 2;
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        this.strict = true;
                        break;
                    }
                    case 2: {
                        this.strict = false;
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
            }
            if (valid && parts[1].equals("time")) {
                var9_12 = parts[2];
                tmp = -1;
                switch (var9_12.hashCode()) {
                    case -1929091532: {
                        if (!var9_12.equals("explicit")) break;
                        tmp = 1;
                        break;
                    }
                    case -425423387: {
                        if (!var9_12.equals("implicit")) break;
                        tmp = 2;
                        break;
                    }
                    case 109935: {
                        if (!var9_12.equals("off")) break;
                        tmp = 3;
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        this.timeMode = TimeMode.OFF;
                        break;
                    }
                    case 2: {
                        this.timeMode = TimeMode.IMPLICIT;
                        break;
                    }
                    case 1: {
                        this.timeMode = TimeMode.EXPLICIT;
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
            }
            if (valid) continue;
            msg = Strings.fmt((String)"Invalid option: \"%s\".", (Object[])new Object[]{line});
            throw new InvalidInputException(msg);
        }
        if (this.strict == null) {
            this.strict = false;
        }
        if (this.timeMode == null) {
            this.timeMode = TimeMode.IMPLICIT;
        }
        this.commands = Lists.listc((int)(lines.size() - i));
        while (i < lines.size()) {
            block58: {
                line = (String)lines.get(i);
                ++i;
                if (line.startsWith("option")) {
                    msg = Strings.fmt((String)"Option after non-option: \"%s\".", (Object[])new Object[]{line});
                    throw new InvalidInputException(msg);
                }
                if (!line.startsWith("event")) break block58;
                parts = StringUtils.split((String)line);
                valid = true;
                if (parts.length != 2) {
                    valid = false;
                }
                if (valid && !parts[0].equals("event")) {
                    valid = false;
                }
                if (!valid) {
                    msg = Strings.fmt((String)"Invalid event command: \"%s\".", (Object[])new Object[]{line});
                    throw new InvalidInputException(msg);
                }
                eventIdx = -1;
                var11_19 = this.spec.events.iterator();
                if (true) ** GOTO lbl168
            }
            if (line.startsWith("time")) {
                if (!line.equals("time")) {
                    msg = Strings.fmt((String)"Invalid time command: \"%s\".", (Object[])new Object[]{line});
                    throw new InvalidInputException(msg);
                }
                if (this.timeMode != TimeMode.EXPLICIT) {
                    msg = "Time command only allowed for explicit time mode.";
                    throw new InvalidInputException(msg);
                }
                this.commands.add(new TimeTraceCommand());
                continue;
            }
            if (!line.startsWith("input")) {
                msg = Strings.fmt((String)"Unknown command: \"%s\".", (Object[])new Object[]{line});
                throw new InvalidInputException(msg);
            }
            parts = StringUtils.split((String)line, null, (int)2);
            valid = true;
            if (parts.length != 2) {
                valid = false;
            }
            if (valid && !parts[0].equals("input")) {
                valid = false;
            }
            if (!valid) {
                msg = Strings.fmt((String)"Invalid input command: \"%s\".", (Object[])new Object[]{line});
                throw new InvalidInputException(msg);
            }
            assign = parts[1].strip();
            terms = StringUtils.split((String)assign, (String)"=", (int)2);
            if (terms.length != 2) {
                msg = Strings.fmt((String)"Invalid input command assignment: \"%s\".", (Object[])new Object[]{assign});
                throw new InvalidInputException(msg);
            }
            varName = terms[0].strip();
            if (varName.isEmpty()) {
                msg = Strings.fmt((String)"Missing input variable in the trace input command assignment \"%s\".", (Object[])new Object[]{assign});
                throw new InvalidInputException(msg);
            }
            varValueTxt = terms[1].strip();
            if (varValueTxt.isEmpty()) {
                msg = Strings.fmt((String)"Missing assigned value in the trace input command assignment \"%s\".", (Object[])new Object[]{assign});
                throw new InvalidInputException(msg);
            }
            inputVarMeta = null;
            var15_23 = this.spec.stateObjectsMeta.iterator();
            if (true) ** GOTO lbl180
            do {
                event = var11_19.next();
                name = event.name.replace("$", "");
                if (event.kind == RuntimeEventKind.ENVIRONMENT || !name.equals(parts[1])) continue;
                eventIdx = event.idx;
                break;
lbl168:
                // 2 sources

            } while (var11_19.hasNext());
            if (eventIdx == -1) {
                msg = Strings.fmt((String)"Event \"%s\" not found.", (Object[])new Object[]{parts[1]});
                throw new InvalidInputException(msg);
            }
            this.commands.add(new EventTraceCommand(eventIdx));
            continue;
            do {
                stateObjMeta = var15_23.next();
                if (stateObjMeta.type != StateObjectType.INPUT || !stateObjMeta.plainName.equals(varName)) continue;
                Assert.check((boolean)(inputVarMeta == null));
                inputVarMeta = stateObjMeta;
lbl180:
                // 3 sources

            } while (var15_23.hasNext());
            if (inputVarMeta == null) {
                msg = Strings.fmt((String)"Input variable \"%s\" assigned through a trace input command doesn't exist.", (Object[])new Object[]{varName});
                throw new InvalidInputException(msg);
            }
            try {
                varValue = varValueTxt.startsWith("t") || varValueTxt.startsWith("f") ? Boolean.valueOf(RuntimeLiteralReader.readBoolLiteral(varValueTxt)) : (varValueTxt.startsWith("+") || varValueTxt.startsWith("-") || Character.isDigit(varValueTxt.charAt(0)) ? (varValueTxt.contains(".") || varValueTxt.contains("e") || varValueTxt.contains("E") ? Double.valueOf(RuntimeLiteralReader.readRealLiteral(varValueTxt)) : Integer.valueOf(RuntimeLiteralReader.readIntLiteral(varValueTxt))) : RuntimeLiteralReader.readStringLiteral(varValueTxt));
            }
            catch (InputOutputException ioe) {
                msg = Strings.fmt((String)"The value \"%s\" assigned to input variable \"%s\" through a trace input mode command is not supported.", (Object[])new Object[]{varValueTxt, varName});
                throw new InvalidInputException(msg);
            }
            this.commands.add(new InputVarUpdateTraceCommand(inputVarMeta, varValue));
        }
        if (!this.strict.booleanValue()) {
            this.autoInput = new AutomaticInputComponent<S>(this.spec);
        }
    }

    @Override
    public List<EventTransition<S>> calcEnvironmentEventTransitions(int environmentEventIdx, S source) {
        if (this.curCommandIdx >= this.commands.size()) {
            return Collections.EMPTY_LIST;
        }
        TraceCommand cmd = this.commands.get(this.curCommandIdx);
        if (cmd instanceof InputVarUpdateTraceCommand) {
            InputVarUpdateTraceCommand inputVarCmd = (InputVarUpdateTraceCommand)cmd;
            RuntimeEvent event = this.spec.events.get(environmentEventIdx);
            TraceInputRuntimeEnvironmentEvent traceInputEvent = (TraceInputRuntimeEnvironmentEvent)event;
            if (inputVarCmd.inputVarMeta.plainName.equals(traceInputEvent.inputVarAbsName)) {
                S target = this.spec.copyState(source);
                traceInputEvent.update(source, target, inputVarCmd);
                boolean stateAllowed = this.spec.evalStateInvPreds(target, false);
                if (stateAllowed) {
                    return Lists.list(new EventTransition<S>(source, traceInputEvent, target));
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Transition<S> chooseTransition(S state, List<Transition<S>> transitions, SimulationResult result) {
        if (transitions.isEmpty()) {
            throw new SimulatorExitException(result);
        }
        if (this.curCommandIdx == this.commands.size()) {
            throw new SimulatorExitException(SimulationResult.USER_TERMINATED);
        }
        TraceCommand cmd = this.commands.get(this.curCommandIdx);
        if (cmd instanceof TimeTraceCommand) {
            Assert.check((this.timeMode == TimeMode.EXPLICIT ? 1 : 0) != 0);
            this.allowDelay = true;
            ++this.curCommandIdx;
            Assert.check((result == null ? 1 : 0) != 0);
            return this.chooseTransition(state, transitions, result);
        }
        if (cmd instanceof EventTraceCommand) {
            EventTraceCommand evtCmd = (EventTraceCommand)cmd;
            RuntimeEvent event = this.spec.events.get(evtCmd.idx);
            Assert.check((event.kind != RuntimeEventKind.ENVIRONMENT ? 1 : 0) != 0);
            List filtered = Lists.listc((int)transitions.size());
            for (Transition<S> transition : transitions) {
                if (!(transition instanceof EventTransition)) continue;
                EventTransition etrans = (EventTransition)transition;
                if (etrans.event != event) continue;
                filtered.add(transition);
            }
            if (filtered.isEmpty() && (this.timeMode == TimeMode.IMPLICIT || this.allowDelay)) {
                Transition lastTrans = null;
                if (!transitions.isEmpty()) {
                    lastTrans = (Transition)Lists.last(transitions);
                }
                if (lastTrans instanceof TimeTransition) {
                    return lastTrans;
                }
            }
            if (filtered.isEmpty()) {
                OutputProvider.warn((String)"No transition found for event \"%s\" from the trace input.", (Object[])new Object[]{event.name});
                throw new SimulatorExitException(SimulationResult.DEADLOCK);
            }
            if (this.strict.booleanValue() && filtered.size() > 1) {
                String msg = Strings.fmt((String)"Multiple transitions are possible for event \"%s\" from the trace input, but strict mode is enabled, which does not allow multiple matches.", (Object[])new Object[]{event.name});
                throw new CifSimulatorException(msg);
            }
            ++this.curCommandIdx;
            this.allowDelay = false;
            if (filtered.size() == 1) {
                return (Transition)Lists.first((List)filtered);
            }
            Assert.check((result == null ? 1 : 0) != 0);
            return this.autoInput.chooseTransition(state, filtered, result);
        }
        if (cmd instanceof InputVarUpdateTraceCommand) {
            InputVarUpdateTraceCommand inputVarCmd = (InputVarUpdateTraceCommand)cmd;
            Transition<S> inputTransition = null;
            for (Transition<S> transition : transitions) {
                if (!(transition instanceof EventTransition)) continue;
                EventTransition etrans = (EventTransition)transition;
                if (!(etrans.event instanceof TraceInputRuntimeEnvironmentEvent)) continue;
                TraceInputRuntimeEnvironmentEvent traceInputEvent = (TraceInputRuntimeEnvironmentEvent)etrans.event;
                Assert.areEqual(inputTransition, null);
                Assert.areEqual((Object)traceInputEvent.inputVarAbsName, (Object)inputVarCmd.inputVarMeta.plainName);
                inputTransition = transition;
            }
            if (inputTransition == null) {
                OutputProvider.warn((String)"No transition found for updating input variable \"%s\" from the trace input.", (Object[])new Object[]{inputVarCmd.inputVarMeta.plainName});
                throw new SimulatorExitException(SimulationResult.DEADLOCK);
            }
            ++this.curCommandIdx;
            this.allowDelay = false;
            return inputTransition;
        }
        throw new RuntimeException("Unknown cmd: " + String.valueOf(cmd));
    }

    @Override
    public ChosenTargetTime chooseTargetTime(S state, double maxTargetTime) {
        Assert.check((this.timeMode != TimeMode.OFF ? 1 : 0) != 0);
        return new ChosenTargetTime(((RuntimeState)state).getTime(), maxTargetTime, true);
    }
}

