/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.Serializable;
import org.htmlunit.cssparser.dom.CSSValueImpl;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.w3c.dom.DOMException;

public class RectImpl
implements Serializable {
    private CSSValueImpl top_;
    private CSSValueImpl right_;
    private CSSValueImpl bottom_;
    private CSSValueImpl left_;

    public RectImpl(LexicalUnit lu) throws DOMException {
        if (lu == null) {
            throw new DOMException(12, "Rect misses first parameter.");
        }
        this.top_ = new CSSValueImpl(lu, true);
        LexicalUnit next = lu.getNextLexicalUnit();
        if (next == null) {
            throw new DOMException(12, "Rect misses second parameter.");
        }
        boolean isCommaSeparated = false;
        if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            isCommaSeparated = true;
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Rect misses second parameter.");
            }
        }
        this.right_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, "Rect misses third parameter.");
        }
        if (isCommaSeparated) {
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, "All or none rect parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Rect misses third parameter.");
            }
        } else if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            throw new DOMException(12, "All or none rect parameters must be separated by ','.");
        }
        this.bottom_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, "Rect misses fourth parameter.");
        }
        if (isCommaSeparated) {
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, "All or none rect parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Rect misses fourth parameter.");
            }
        } else if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            throw new DOMException(12, "All or none rect parameters must be separated by ','.");
        }
        this.left_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) != null) {
            throw new DOMException(12, "Too many parameters for rect function.");
        }
    }

    public CSSValueImpl getTop() {
        return this.top_;
    }

    public void setTop(CSSValueImpl top) {
        this.top_ = top;
    }

    public CSSValueImpl getRight() {
        return this.right_;
    }

    public void setRight(CSSValueImpl right) {
        this.right_ = right;
    }

    public CSSValueImpl getBottom() {
        return this.bottom_;
    }

    public void setBottom(CSSValueImpl bottom) {
        this.bottom_ = bottom;
    }

    public CSSValueImpl getLeft() {
        return this.left_;
    }

    public void setLeft(CSSValueImpl left) {
        this.left_ = left;
    }

    public String toString() {
        return "rect(" + this.top_ + ", " + this.right_ + ", " + this.bottom_ + ", " + this.left_ + ")";
    }
}

