/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.util.ParserUtils;

public class CSSRuleListImpl
implements Serializable {
    private final List<AbstractCSSRuleImpl> rules_ = new ArrayList<AbstractCSSRuleImpl>();

    public List<AbstractCSSRuleImpl> getRules() {
        return this.rules_;
    }

    public int getLength() {
        return this.getRules().size();
    }

    public void add(AbstractCSSRuleImpl rule) {
        this.getRules().add(rule);
    }

    public void insert(AbstractCSSRuleImpl rule, int index) {
        this.getRules().add(index, rule);
    }

    public void delete(int index) {
        this.getRules().remove(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AbstractCSSRuleImpl rule : this.rules_) {
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(rule.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSRuleListImpl)) {
            return false;
        }
        CSSRuleListImpl crl = (CSSRuleListImpl)obj;
        return this.equalsRules(crl);
    }

    private boolean equalsRules(CSSRuleListImpl crl) {
        if (crl == null || this.getLength() != crl.getLength()) {
            return false;
        }
        int i = 0;
        for (AbstractCSSRuleImpl rule : this.rules_) {
            AbstractCSSRuleImpl cssRule2;
            if (!ParserUtils.equals(rule, cssRule2 = crl.rules_.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = ParserUtils.hashCode(hash, this.rules_);
        return hash;
    }
}

