/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.workset.pruners;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.cif.bdd.workset.pruners.EdgePruner;
import org.eclipse.escet.common.java.BitSets;

public class MaxCardinalityEdgePruner
extends EdgePruner {
    private final int[] cardinalities;

    public MaxCardinalityEdgePruner(List<BitSet> dependencies) {
        this.cardinalities = dependencies.stream().mapToInt(BitSet::cardinality).toArray();
    }

    @Override
    public BitSet pruneInternal(BitSet workset) {
        int max = -1;
        Iterator iterator = BitSets.iterateTrueBits((BitSet)workset).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int cardinality = this.cardinalities[i];
            if (cardinality < max) {
                workset.clear(i);
                continue;
            }
            if (cardinality <= max) continue;
            max = cardinality;
            workset.clear(0, i);
        }
        return workset;
    }

    @Override
    public void update(int edgeIdx, boolean hadAnEffect) {
    }
}

