/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.ecore.delegates.DelegateLabelProvider;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class ExeedLabelProvider
implements DelegateLabelProvider {
    private final EolModule module;
    private final EValidator.SubstitutionLabelProvider delegate;

    public ExeedLabelProvider() {
        this(new EolModule(), new SimpleProvider());
    }

    public ExeedLabelProvider(EolModule module, EValidator.SubstitutionLabelProvider delegate) {
        this.module = module;
        this.delegate = delegate;
    }

    public String getObjectLabel(EObject eObject) {
        String labelCode = this.getEClassAnnotationDetail(eObject, "exeed", "label");
        try {
            if (labelCode != null && this.parse(labelCode)) {
                FrameStack frameStack = this.module.getContext().getFrameStack();
                frameStack.enterLocal(FrameType.UNPROTECTED, null, new Variable[]{Variable.createReadOnlyVariable((String)"self", (Object)eObject), Variable.createReadOnlyVariable((String)"thisModule", (Object)this.module)});
                String label = StringUtil.toString((Object)this.module.execute());
                frameStack.leaveLocal(null);
                return label;
            }
        }
        catch (Exception exception) {}
        return this.delegate.getObjectLabel(eObject);
    }

    public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
        Object detailValue;
        EAnnotation eAnnotation = eStructuralFeature.getEAnnotation("exeed");
        if (eAnnotation != null && (detailValue = eAnnotation.getDetails().get((Object)"featureLabel")) != null) {
            return detailValue.toString();
        }
        return this.delegate.getFeatureLabel(eStructuralFeature);
    }

    public String getValueLabel(EDataType eDataType, Object value) {
        return this.delegate.getValueLabel(eDataType, value);
    }

    @Override
    public DelegateLabelProvider delegate(EValidator.SubstitutionLabelProvider delegate) {
        return new ExeedLabelProvider(this.module, delegate);
    }

    private boolean parse(String code) throws Exception {
        return this.module.parse(code);
    }

    private String getEClassAnnotationDetail(EObject eObject, String annotation, String detail) {
        return this.getEClassAnnotationDetail(eObject.eClass(), annotation, detail);
    }

    private String getEClassAnnotationDetail(EClass eClass, String annotation, String detail) {
        Object detailValue;
        EAnnotation eAnnotation = eClass.getEAnnotation(annotation);
        if (eAnnotation != null && (detailValue = eAnnotation.getDetails().get((Object)detail)) != null) {
            return detailValue.toString();
        }
        if (eClass.getESuperTypes().size() > 0) {
            for (EClass superType : eClass.getESuperTypes()) {
                String detailValue2 = this.getEClassAnnotationDetail(superType, annotation, detail);
                if (detailValue2 == null) continue;
                return detailValue2;
            }
        }
        return null;
    }

    private static class SimpleProvider
    implements EValidator.SubstitutionLabelProvider {
        private SimpleProvider() {
        }

        public String getObjectLabel(EObject eObject) {
            return EcoreUtil.getIdentification((EObject)eObject);
        }

        public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature.getName();
        }

        public String getValueLabel(EDataType eDataType, Object value) {
            return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
        }
    }
}

