/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.template.model.VTControlValidationTemplate;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTTemplateFactory;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.validation.model.VTValidationStyleProperty;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class SWTValidationHelper {
    public static final SWTValidationHelper INSTANCE = new SWTValidationHelper();
    private final Map<String, Color> colorMap = new LinkedHashMap<String, Color>();
    private VTViewTemplate defaultTemplate;

    private SWTValidationHelper() {
    }

    public Color getValidationBackgroundColor(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTControlValidationTemplate template = this.getTemplate().getControlValidationConfiguration();
        String colorHex = null;
        switch (severity) {
            case 0: {
                colorHex = this.getOkColorHEX(template, vElement, viewModelContext);
                break;
            }
            case 1: {
                colorHex = this.getInfoColorHEX(template, vElement, viewModelContext);
                break;
            }
            case 2: {
                colorHex = this.getWarningColorHEX(template, vElement, viewModelContext);
                break;
            }
            case 4: {
                colorHex = this.getErrorColorHEX(template, vElement, viewModelContext);
                break;
            }
            case 8: {
                colorHex = this.getCancelColorHEX(template, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (colorHex == null) {
            return null;
        }
        if (!this.colorMap.containsKey(colorHex)) {
            this.colorMap.put(colorHex, this.getColor(colorHex));
        }
        return this.colorMap.get(colorHex);
    }

    public Color getValidationBackgroundColor(int severity) {
        return this.getValidationBackgroundColor(severity, null, null);
    }

    public Image getValidationIcon(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTControlValidationTemplate template = this.getTemplate().getControlValidationConfiguration();
        String imageUrl = null;
        switch (severity) {
            case 0: {
                imageUrl = this.getOkImageURL(template, vElement, viewModelContext);
                break;
            }
            case 1: {
                imageUrl = this.getInfoImageURL(template, vElement, viewModelContext);
                break;
            }
            case 2: {
                imageUrl = this.getWarningImageURL(template, vElement, viewModelContext);
                break;
            }
            case 4: {
                imageUrl = this.getErrorImageURL(template, vElement, viewModelContext);
                break;
            }
            case 8: {
                imageUrl = this.getCancelImageURL(template, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (imageUrl == null) {
            return null;
        }
        try {
            return Activator.getImage(new URL(imageUrl));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Image getValidationIcon(int severity) {
        return this.getValidationIcon(severity, null, null);
    }

    public ImageDescriptor getValidationOverlayDescriptor(int severity, VElement vElement, ViewModelContext viewModelContext) {
        VTControlValidationTemplate template = this.getTemplate().getControlValidationConfiguration();
        String imageUrl = null;
        switch (severity) {
            case 0: {
                imageUrl = this.getOkOverlayURL(template, vElement, viewModelContext);
                break;
            }
            case 1: {
                imageUrl = this.getInfoOverlayURL(template, vElement, viewModelContext);
                break;
            }
            case 2: {
                imageUrl = this.getWarningOverlayURL(template, vElement, viewModelContext);
                break;
            }
            case 4: {
                imageUrl = this.getErrorOverlayURL(template, vElement, viewModelContext);
                break;
            }
            case 8: {
                imageUrl = this.getCancelOverlayURL(template, vElement, viewModelContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified severity value " + severity + " is invalid. See Diagnostic class.");
            }
        }
        if (imageUrl == null) {
            return null;
        }
        try {
            return ImageDescriptor.createFromURL((URL)new URL(imageUrl));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ImageDescriptor getValidationOverlayDescriptor(int severity) {
        return this.getValidationOverlayDescriptor(severity, null, null);
    }

    private String getOkColorHEX(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            colorHex = template.getOkColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getOkColorHEX();
        }
        return colorHex;
    }

    private String getInfoColorHEX(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            colorHex = template.getInfoColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getInfoColorHEX();
        }
        return colorHex;
    }

    private String getWarningColorHEX(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            colorHex = template.getWarningColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getWarningColorHEX();
        }
        return colorHex;
    }

    private String getErrorColorHEX(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            colorHex = template.getErrorColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getErrorColorHEX();
        }
        return colorHex;
    }

    private String getCancelColorHEX(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String colorHex = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            colorHex = template.getCancelColorHEX();
        }
        if (validationStyleProperty != null) {
            colorHex = validationStyleProperty.getCancelColorHEX();
        }
        return colorHex;
    }

    private String getOkImageURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            imageURL = template.getOkImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getOkImageURL();
        }
        return imageURL;
    }

    private String getInfoImageURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            imageURL = template.getInfoImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getInfoImageURL();
        }
        return imageURL;
    }

    private String getWarningImageURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            imageURL = template.getWarningImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getWarningImageURL();
        }
        return imageURL;
    }

    private String getErrorImageURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            imageURL = template.getErrorImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getErrorImageURL();
        }
        return imageURL;
    }

    private String getCancelImageURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String imageURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            imageURL = template.getCancelImageURL();
        }
        if (validationStyleProperty != null) {
            imageURL = validationStyleProperty.getCancelImageURL();
        }
        return imageURL;
    }

    private String getOkOverlayURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            overlayURL = template.getOkOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getOkOverlayURL();
        }
        return overlayURL;
    }

    private String getInfoOverlayURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            overlayURL = template.getInfoOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getInfoOverlayURL();
        }
        return overlayURL;
    }

    private String getWarningOverlayURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            overlayURL = template.getWarningOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getWarningOverlayURL();
        }
        return overlayURL;
    }

    private String getErrorOverlayURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            overlayURL = template.getErrorOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getErrorOverlayURL();
        }
        return overlayURL;
    }

    private String getCancelOverlayURL(VTControlValidationTemplate template, VElement vElement, ViewModelContext viewModelContext) {
        String overlayURL = null;
        VTValidationStyleProperty validationStyleProperty = this.getValidationStyleProperty(vElement, viewModelContext);
        if (template != null) {
            overlayURL = template.getCancelOverlayURL();
        }
        if (validationStyleProperty != null) {
            overlayURL = validationStyleProperty.getCancelOverlayURL();
        }
        return overlayURL;
    }

    private VTValidationStyleProperty getValidationStyleProperty(VElement vElement, ViewModelContext viewModelContext) {
        VTValidationStyleProperty validationStyleProperty = null;
        if (vElement != null && viewModelContext != null) {
            VTViewTemplateProvider vtViewTemplateProvider = Activator.getDefault().getVTViewTemplateProvider();
            if (vtViewTemplateProvider == null) {
                return validationStyleProperty;
            }
            Set styleProperties = vtViewTemplateProvider.getStyleProperties(vElement, viewModelContext);
            for (VTStyleProperty styleProperty : styleProperties) {
                if (!VTValidationStyleProperty.class.isInstance(styleProperty)) continue;
                validationStyleProperty = (VTValidationStyleProperty)VTValidationStyleProperty.class.cast(styleProperty);
                break;
            }
        }
        return validationStyleProperty;
    }

    private VTViewTemplate getTemplate() {
        VTViewTemplateProvider vtViewTemplateProvider = Activator.getDefault().getVTViewTemplateProvider();
        if (vtViewTemplateProvider == null || vtViewTemplateProvider.getViewTemplate() == null) {
            if (this.defaultTemplate == null) {
                this.defaultTemplate = VTTemplateFactory.eINSTANCE.createViewTemplate();
                VTControlValidationTemplate validationTemplate = VTTemplateFactory.eINSTANCE.createControlValidationTemplate();
                this.defaultTemplate.setControlValidationConfiguration(validationTemplate);
                validationTemplate.setOkColorHEX("ffffff");
                validationTemplate.setErrorColorHEX("ff0000");
                validationTemplate.setWarningColorHEX("FFD800");
                validationTemplate.setErrorImageURL(Activator.getDefault().getBundle().getResource("icons/validation_error.png").toExternalForm());
                validationTemplate.setErrorOverlayURL(Activator.getDefault().getBundle().getResource("icons/error_decorate.png").toExternalForm());
                validationTemplate.setWarningOverlayURL(Activator.getDefault().getBundle().getResource("icons/warning_decorate.png").toExternalForm());
                validationTemplate.setInfoOverlayURL(Activator.getDefault().getBundle().getResource("icons/info_decorate.gif").toExternalForm());
            }
            return this.defaultTemplate;
        }
        return vtViewTemplateProvider.getViewTemplate();
    }

    private Color getColor(String colorHex) {
        String redString = colorHex.substring(0, 2);
        String greenString = colorHex.substring(2, 4);
        String blueString = colorHex.substring(4, 6);
        int red = Integer.parseInt(redString, 16);
        int green = Integer.parseInt(greenString, 16);
        int blue = Integer.parseInt(blueString, 16);
        return new Color((Device)Display.getDefault(), red, green, blue);
    }
}

