/*******************************************************************************
 * Copyright (c) 2008-2011 Chair for Applied Software Engineering,
 * Technische Universitaet Muenchen.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 ******************************************************************************/
package org.eclipse.emf.emfstore.internal.server.model.versioning.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AncestorVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.DateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HeadVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ModelElementQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.OperationProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PagedUpdateVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PathQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.RangeQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionProperty;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It provides
 * an adapter <code>createXXX</code> method for each class of the model. <!--
 * end-user-doc -->
 *
 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage
 * @generated
 */
public class VersioningAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected static VersioningPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 *
	 * @generated
	 */
	public VersioningAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = VersioningPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This implementation returns <code>true</code> if
	 * the object is either the model's package or is an instance object of the
	 * model. <!-- end-user-doc -->
	 *
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject) object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected VersioningSwitch<Adapter> modelSwitch = new VersioningSwitch<Adapter>() {
		@Override
		public Adapter caseTagVersionSpec(TagVersionSpec object) {
			return createTagVersionSpecAdapter();
		}

		@Override
		public Adapter caseDateVersionSpec(DateVersionSpec object) {
			return createDateVersionSpecAdapter();
		}

		@Override
		public Adapter casePrimaryVersionSpec(PrimaryVersionSpec object) {
			return createPrimaryVersionSpecAdapter();
		}

		@Override
		public Adapter caseVersionSpec(VersionSpec object) {
			return createVersionSpecAdapter();
		}

		@Override
		public Adapter caseLogMessage(LogMessage object) {
			return createLogMessageAdapter();
		}

		@Override
		public Adapter caseChangePackage(ChangePackage object) {
			return createChangePackageAdapter();
		}

		@Override
		public Adapter caseHistoryInfo(HistoryInfo object) {
			return createHistoryInfoAdapter();
		}

		@Override
		public Adapter caseHistoryQuery(@SuppressWarnings("rawtypes") HistoryQuery object) {
			return createHistoryQueryAdapter();
		}

		@Override
		public Adapter caseRangeQuery(@SuppressWarnings("rawtypes") RangeQuery object) {
			return createRangeQueryAdapter();
		}

		@Override
		public Adapter casePathQuery(PathQuery object) {
			return createPathQueryAdapter();
		}

		@Override
		public Adapter caseModelElementQuery(ModelElementQuery object) {
			return createModelElementQueryAdapter();
		}

		@Override
		public Adapter caseVersion(Version object) {
			return createVersionAdapter();
		}

		@Override
		public Adapter caseHeadVersionSpec(HeadVersionSpec object) {
			return createHeadVersionSpecAdapter();
		}

		@Override
		public Adapter caseVersionProperty(VersionProperty object) {
			return createVersionPropertyAdapter();
		}

		@Override
		public Adapter caseBranchVersionSpec(BranchVersionSpec object) {
			return createBranchVersionSpecAdapter();
		}

		@Override
		public Adapter caseBranchInfo(BranchInfo object) {
			return createBranchInfoAdapter();
		}

		@Override
		public Adapter caseAncestorVersionSpec(AncestorVersionSpec object) {
			return createAncestorVersionSpecAdapter();
		}

		@Override
		public Adapter casePagedUpdateVersionSpec(PagedUpdateVersionSpec object) {
			return createPagedUpdateVersionSpecAdapter();
		}

		@Override
		public Adapter caseAbstractChangePackage(AbstractChangePackage object) {
			return createAbstractChangePackageAdapter();
		}

		@Override
		public Adapter caseFileBasedChangePackage(FileBasedChangePackage object) {
			return createFileBasedChangePackageAdapter();
		}

		@Override
		public Adapter caseOperationProxy(OperationProxy object) {
			return createOperationProxyAdapter();
		}

		@Override
		public Adapter caseChangePackageEnvelope(ChangePackageEnvelope object) {
			return createChangePackageEnvelopeAdapter();
		}

		@Override
		public Adapter caseChangePackageProxy(ChangePackageProxy object) {
			return createChangePackageProxyAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject) target);
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec <em>Tag Version Spec</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec
	 * @generated
	 */
	public Adapter createTagVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.DateVersionSpec <em>Date Version Spec</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.DateVersionSpec
	 * @generated
	 */
	public Adapter createDateVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec
	 * <em>Primary Version Spec</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec
	 * @generated
	 */
	public Adapter createPrimaryVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec <em>Version Spec</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec
	 * @generated
	 */
	public Adapter createVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage <em>Log Message</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage
	 * @generated
	 */
	public Adapter createLogMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage <em>Change Package</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage
	 * @generated
	 */
	public Adapter createChangePackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo <em>History Info</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo
	 * @generated
	 */
	public Adapter createHistoryInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery <em>History Query</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery
	 * @generated
	 */
	public Adapter createHistoryQueryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.RangeQuery <em>Range Query</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.RangeQuery
	 * @generated
	 */
	public Adapter createRangeQueryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.PathQuery <em>Path Query</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.PathQuery
	 * @generated
	 */
	public Adapter createPathQueryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.ModelElementQuery <em>Model Element Query</em>}
	 * '.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.ModelElementQuery
	 * @generated
	 */
	public Adapter createModelElementQueryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.Version
	 * <em>Version</em>}'. <!-- begin-user-doc --> This default implementation
	 * returns null so that we can easily ignore cases; it's useful to ignore a
	 * case when inheritance will catch all the cases anyway. <!-- end-user-doc
	 * -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.Version
	 * @generated
	 */
	public Adapter createVersionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.HeadVersionSpec <em>Head Version Spec</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.HeadVersionSpec
	 * @generated
	 */
	public Adapter createHeadVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.VersionProperty <em>Version Property</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.VersionProperty
	 * @generated
	 */
	public Adapter createVersionPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec <em>Branch Version Spec</em>}
	 * '.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec
	 * @generated
	 */
	public Adapter createBranchVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo <em>Branch Info</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo
	 * @generated
	 */
	public Adapter createBranchInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.AncestorVersionSpec
	 * <em>Ancestor Version Spec</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's
	 * useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.AncestorVersionSpec
	 * @generated
	 */
	public Adapter createAncestorVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.PagedUpdateVersionSpec
	 * <em>Paged Update Version Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.PagedUpdateVersionSpec
	 * @generated
	 */
	public Adapter createPagedUpdateVersionSpecAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage
	 * <em>Abstract Change Package</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage
	 * @generated
	 */
	public Adapter createAbstractChangePackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage
	 * <em>File Based Change Package</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage
	 * @generated
	 */
	public Adapter createFileBasedChangePackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null. <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

	public Adapter createOperationProxyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope
	 * <em>Change Package Envelope</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope
	 * @generated
	 */
	public Adapter createChangePackageEnvelopeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '
	 * {@link org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageProxy
	 * <em>Change Package Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 *
	 * @return the new adapter.
	 * @see org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageProxy
	 * @generated
	 */
	public Adapter createChangePackageProxyAdapter() {
		return null;
	}

} // VersioningAdapterFactory