/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ide.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EcoreHelper {
    private static final String ECORE_PLUGIN_URI = "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.ecore";
    private static final String ECORE_RESOURCE_URI = "platform:/resource/org.eclipse.emf.ecore/model/Ecore.ecore";
    private static final Map<String, Set<String>> registeredEPackages = new HashMap<String, Set<String>>();
    private static final Map<String, Integer> registeredEcores = new HashMap<String, Integer>();
    private static final Set<String> runtimeRegisteredPackages = new HashSet<String>();

    private EcoreHelper() {
    }

    public static void registerEcore(String ecorePath) throws IOException {
        if (ecorePath == null) {
            return;
        }
        Integer previousValue = registeredEcores.get(ecorePath);
        if (previousValue == null || previousValue < 0) {
            previousValue = 0;
        }
        previousValue = previousValue + 1;
        registeredEcores.put(ecorePath, previousValue);
        ResourceSetImpl physicalResourceSet = new ResourceSetImpl();
        EcoreHelper.initResourceSet((ResourceSet)physicalResourceSet);
        URI uri = URI.createPlatformResourceURI((String)ecorePath, (boolean)false);
        Resource r = physicalResourceSet.createResource(uri);
        r.load(null);
        int rsSize = physicalResourceSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
        while (rsSize != physicalResourceSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)physicalResourceSet);
            rsSize = physicalResourceSet.getResources().size();
        }
        ResourceSetImpl virtualResourceSet = new ResourceSetImpl();
        for (Resource physicalResource : physicalResourceSet.getResources()) {
            if (physicalResource.getContents().size() == 0) continue;
            EObject eObject = (EObject)physicalResource.getContents().get(0);
            EPackage ePackage = (EPackage)EPackage.class.cast(eObject);
            if (registeredEPackages.get(ecorePath) == null) {
                registeredEPackages.put(ecorePath, new HashSet());
            }
            registeredEPackages.get(ecorePath).add(ePackage.getNsURI());
            if (EcoreHelper.isContainedInPackageRegistry(ePackage.getNsURI())) continue;
            physicalResource.getContents().remove((Object)ePackage);
            Resource virtualResource = virtualResourceSet.createResource(URI.createURI((String)ePackage.getNsURI()));
            virtualResource.getContents().add((Object)ePackage);
            EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
            runtimeRegisteredPackages.add(ePackage.getNsURI());
        }
    }

    private static boolean isContainedInPackageRegistry(String nsURI) {
        EPackage.Registry instance = EPackage.Registry.INSTANCE;
        return instance.containsKey((Object)nsURI);
    }

    public static void unregisterEcore(String ecorePath) {
        if (ecorePath == null || registeredEPackages.get(ecorePath) == null) {
            return;
        }
        int usages = registeredEcores.get(ecorePath);
        registeredEcores.put(ecorePath, --usages);
        if (usages > 0) {
            return;
        }
        ArrayList<String> nsURIs = new ArrayList<String>((Collection)registeredEPackages.get(ecorePath));
        EcoreHelper.unregisterEcore(ecorePath, nsURIs);
    }

    private static void unregisterEcore(String ecorePath, List<String> nsURIs) {
        if (nsURIs == null || ecorePath == null) {
            return;
        }
        for (String nsURI : nsURIs) {
            if (EcoreHelper.getUsageCount(nsURI) != 1 || !runtimeRegisteredPackages.contains(nsURI)) continue;
            EPackage.Registry registry = EPackage.Registry.INSTANCE;
            registry.remove((Object)nsURI);
            registeredEPackages.get(ecorePath).remove(nsURI);
        }
        registeredEPackages.remove(ecorePath);
    }

    private static int getUsageCount(String nsURI) {
        int usage = 0;
        for (String ecore : registeredEPackages.keySet()) {
            for (String uri : registeredEPackages.get(ecore)) {
                if (!nsURI.equals(uri)) continue;
                ++usage;
            }
        }
        return usage;
    }

    public static Object[] getDefaultPackageRegistryContents() {
        HashSet packages = new HashSet();
        packages.addAll(EPackage.Registry.INSTANCE.keySet());
        packages.removeAll(runtimeRegisteredPackages);
        return packages.toArray();
    }

    private static void initResourceSet(ResourceSet resourceSet) {
        if (!resourceSet.getURIConverter().exists(URI.createURI((String)ECORE_RESOURCE_URI), null)) {
            resourceSet.getURIConverter().getURIMap().put(URI.createURI((String)ECORE_RESOURCE_URI), URI.createURI((String)ECORE_PLUGIN_URI));
        }
    }
}

