/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class Util {
    private static final String FXML_NAMESPACE = "http://javafx.com/fxml";
    private static final String FXML_NAMESPACE_1 = "http://javafx.com/fxml/1";

    public static final boolean isFXMLNamespace(String value) {
        return FXML_NAMESPACE.equals(value) || FXML_NAMESPACE_1.equals(value);
    }

    public static Attr getFXMLAttribute(Element e, String localName) {
        Attr attribute = e.getAttributeNodeNS(FXML_NAMESPACE, localName);
        if (attribute == null) {
            attribute = e.getAttributeNodeNS(FXML_NAMESPACE_1, localName);
        }
        return attribute;
    }

    static IJavaProject findProject(Document xmlDoc) {
        String baseLocation = ((IDOMNode)xmlDoc).getModel().getBaseLocation();
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(baseLocation));
        return JavaCore.create((IProject)f.getProject());
    }

    public static List<String> getImportedTypes(Document xmlDoc) {
        NodeList list = xmlDoc.getChildNodes();
        ArrayList<String> imports = new ArrayList<String>();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n.getNodeType() == 7) {
                String data = ((ProcessingInstruction)n).getData();
                if (data.endsWith("?")) {
                    data = data.substring(0, data.length() - 1);
                }
                imports.add(data);
            }
            ++i;
        }
        return imports;
    }

    public static IType findType(String name, Document xmlDoc) {
        IType t;
        IJavaProject jpProject = Util.findProject(xmlDoc);
        if (name.contains(".")) {
            try {
                IType t2 = jpProject.findType(name);
                if (t2 != null) {
                    return t2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        List<String> imports = Util.getImportedTypes(xmlDoc);
        for (String i : imports) {
            if (!i.endsWith("." + name)) continue;
            try {
                t = jpProject.findType(i);
                if (t == null) continue;
                return t;
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        for (String i : imports) {
            if (!i.endsWith("*")) continue;
            try {
                t = jpProject.findType(i.substring(0, i.length() - 1) + name);
                if (t == null) continue;
                return t;
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

