/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueSender;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedQueueSenderTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueSender.ClosedQueueSenderTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueSenderTests theTests = new ClosedQueueSenderTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSender() throws Exception {
        this.tool = new JmsTool(0, this.user, this.password, this.mode);
        this.tool.getDefaultQueueConnection().start();
        this.logTrace("Closing queue sender");
        this.tool.getDefaultQueueSender().close();
        this.logTrace("Sender closed");
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedQueueSenderCloseTest() throws Exception {
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderCloseTest", e);
        }
    }

    public void closedQueueSenderGetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderGetDeliveryModeTest", e);
        }
    }

    public void closedQueueSenderGetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderGetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSenderGetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderGetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSenderGetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderGetPriorityTest", e);
        }
    }

    public void closedQueueSenderGetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderGetTimeToLiveTest", e);
        }
    }

    public void closedQueueSenderSetDeliveryModeTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSetDeliveryModeTest", e);
        }
    }

    public void closedQueueSenderSetDisableMessageIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSenderSetDisableMessageTimestampTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSenderSetPriorityTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSetPriorityTest", e);
        }
    }

    public void closedQueueSenderSetTimeToLiveTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSetTimeToLiveTest", e);
        }
    }

    public void closedQueueSenderGetQueueTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderGetQueueTest", e);
        }
    }

    public void closedQueueSenderSend1Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSend1Test", e);
        }
    }

    public void closedQueueSenderSend2Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSend2Test", e);
        }
    }

    public void closedQueueSenderSend3Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSend3Test", e);
        }
    }

    public void closedQueueSenderSend4Test() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseSender();
            this.logTrace("Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueSenderSend4Test", e);
        }
    }
}

